/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CPUManager {
    public static final int DEVICEINFO_UNKNOWN = -1;
    public int CPU_index = 0;
    public int sample_fre = 10;

    public CPUManager(int n) {
        this.CPU_index = n;
    }

    public boolean isOnline() {
        String string = "";
        InputStream inputStream = null;
        try {
            String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu" + this.CPU_index + "/online"};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
            }
            if (string2.equals("1")) {
                return true;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public int getMaxCpuFreq() {
        String string = "";
        String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu" + this.CPU_index + "/cpufreq/cpuinfo_max_freq"};
        if (!this.isOnline()) {
            stringArray[1] = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            byte[] byArray = new byte[24];
            while (inputStream.read(byArray) != -1) {
                string = string + new String(byArray);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            string = "0";
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        int n = Integer.parseInt(string.trim()) / 1024;
        return n;
    }

    public int getMinCpuFreq() {
        String string = "";
        String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu" + this.CPU_index + "/cpufreq/cpuinfo_min_freq"};
        if (!this.isOnline()) {
            stringArray[1] = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq";
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            byte[] byArray = new byte[24];
            while (inputStream.read(byArray) != -1) {
                string = string + new String(byArray);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            string = "-1";
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        int n = Integer.parseInt(string.trim()) / 1024;
        return n;
    }

    public int getCurCpuFreq() {
        String string = "";
        int n = 0;
        if (!this.isOnline()) {
            string = "0";
            return 0;
        }
        try {
            FileReader fileReader = new FileReader("/sys/devices/system/cpu/cpu" + this.CPU_index + "/cpufreq/scaling_cur_freq");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            string = string2.trim();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        n = Integer.parseInt(string) / 1024;
        return n;
    }

    public static String getCpuName() {
        try {
            FileReader fileReader = new FileReader("/proc/cpuinfo");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(":\\s+", 2);
            for (int i = 0; i < stringArray.length; ++i) {
            }
            return stringArray[1];
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static int getNumCores() {
        try {
            File file = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]", file.getName());
                }
            }
            File[] fileArray = file.listFiles(new CpuFilter());
            return fileArray.length;
        }
        catch (Exception exception) {
            Log.e((String)"cxq", (String)"CPU Count: Failed.");
            exception.printStackTrace();
            return 1;
        }
    }

    public double getUsage() {
        Object object;
        double d = 0.0;
        try {
            object = this.getCPUData();
            long l = object.get("idle");
            long l2 = (Long)object.get("total_time");
            Thread.sleep(this.sample_fre);
            Map<String, Long> map = this.getCPUData();
            long l3 = map.get("idle");
            long l4 = map.get("total_time");
            double d2 = l3 - l;
            double d3 = l4 - l2;
            if (d3 == 0.0) {
                return 0.0;
            }
            d = (d3 - d2) / d3;
            d = Math.abs(d * 100.0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        object = new DecimalFormat("#.00");
        d = Double.parseDouble(((NumberFormat)object).format(d));
        return d;
    }

    public Map<String, Long> getCPUData() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            arrayList2.add(0L);
        }
        String string = "cpu" + this.CPU_index;
        if (this.CPU_index == -1) {
            string = "cpu";
        }
        String string2 = "";
        String[] stringArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            while ((string2 = bufferedReader.readLine()) != null && !string2.contains(string)) {
                string2 = "";
            }
            bufferedReader.close();
            if (string2 == null || string2.equals("")) {
                hashMap.put("total_time", 0L);
                hashMap.put("idle", 0L);
                return hashMap;
            }
            stringArray = string2.split(" ");
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].trim().equals("")) continue;
                arrayList.add(Long.parseLong(stringArray[i]));
            }
        }
        catch (IOException iOException) {
            Log.e((String)"CPU", (String)("IOException" + iOException.toString()));
            hashMap.put("total_time", 0L);
            hashMap.put("idle", 0L);
            return hashMap;
        }
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l += ((Long)arrayList.get(i)).longValue();
        }
        hashMap.put("total_time", l);
        hashMap.put("idle", (Long)arrayList.get(3));
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getMaxCpuFrequence() {
        float f = 0.0f;
        try {
            Object object;
            int n;
            String[] stringArray;
            Object object2;
            Object object3;
            String string;
            for (int i = 0; i < CPUManager.getNumCores(); ++i) {
                string = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                object3 = new File(string);
                if (!((File)object3).exists()) continue;
                object2 = new byte[128];
                stringArray = new FileInputStream((File)object3);
                try {
                    stringArray.read((byte[])object2);
                    for (n = 0; object2[n] >= 48 && object2[n] <= 57 && n < ((Object)object2).length; ++n) {
                    }
                    object = new String((byte[])object2, 0, n);
                    Float f2 = Float.valueOf((String)object);
                    if (!(f2.floatValue() > f)) continue;
                    f = f2.floatValue();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                finally {
                    stringArray.close();
                }
            }
            if (f == -1.0f) {
                String string2 = "";
                string = "";
                try {
                    object3 = new FileReader("/proc/cpuinfo");
                    object2 = new BufferedReader((Reader)object3);
                    while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                        if (!string2.contains("cpu MHz") || !(string = string2.split(":")[1]).contains(" ")) continue;
                        stringArray = string.split(" ");
                        n = stringArray[stringArray.length - 1].lastIndexOf(".");
                        object = Float.valueOf(string2.substring(0, n));
                        if (!(((Float)(object = Float.valueOf(((Float)object).floatValue() * 1000.0f))).floatValue() > f)) continue;
                        f = ((Float)object).floatValue();
                    }
                    ((BufferedReader)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f / 1000000.0f;
    }

    public static String getCpuModel() {
        String string = "/proc/cpuinfo";
        String string2 = "";
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.contains("Hardware")) continue;
                bufferedReader.close();
                return string2.split(":")[1].trim();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Build.HARDWARE;
    }

    public static float getTotalMemory() {
        float f = -1.0f;
        try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
            f = CPUManager.parseFileForValue("MemTotal", fileInputStream);
            f /= 1024.0f;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f;
    }

    private static int parseFileForValue(String string, FileInputStream fileInputStream) {
        byte[] byArray = new byte[1024];
        try {
            int n = fileInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                int n2;
                if (byArray[i] != 10 && i != 0) continue;
                if (byArray[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < n && byArray[j] == string.charAt(n2 = j - i); ++j) {
                    if (n2 != string.length() - 1) continue;
                    return CPUManager.extractValue(byArray, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] != 10) {
            if (Character.isDigit(byArray[n])) {
                int n2 = n++;
                while (n < byArray.length && Character.isDigit(byArray[n])) {
                    ++n;
                }
                String string = new String(byArray, 0, n2, n - n2);
                return Integer.parseInt(string);
            }
            ++n;
        }
        return -1;
    }
}

