/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.repository.exception.MultipleEntityGraphException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;

class RepositoryMethodInvocation {
    private final MethodInvocation invocation;

    public RepositoryMethodInvocation(MethodInvocation invocation) {
        this.invocation = invocation;
    }

    public Object proceed() throws Throwable {
        return this.invocation.proceed();
    }

    public Object repository() {
        if (this.invocation instanceof ProxyMethodInvocation) {
            return ((ProxyMethodInvocation)this.invocation).getProxy();
        }
        Object repository = this.invocation.getThis();
        return Objects.requireNonNull(repository, "No qualifier found for invocation " + String.valueOf(repository));
    }

    public Method method() {
        return this.invocation.getMethod();
    }

    public Object[] arguments() {
        return this.invocation.getArguments();
    }

    public EntityGraph findEntityGraphArgument() {
        EntityGraph providedEntityGraph = null;
        for (Object argument : this.invocation.getArguments()) {
            if (!(argument instanceof EntityGraph)) continue;
            EntityGraph newEntityGraph = (EntityGraph)argument;
            if (providedEntityGraph != null) {
                throw new MultipleEntityGraphException("Duplicate EntityGraphs detected. '" + String.valueOf(providedEntityGraph) + "' and '" + String.valueOf(newEntityGraph) + "' were passed to method " + String.valueOf(this.invocation.getMethod()));
            }
            providedEntityGraph = newEntityGraph;
        }
        return providedEntityGraph;
    }
}

