/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.repository.EntityGraphRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.support.RepositoryMethodInvocation;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisedSupportListener;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

class DefaultEntityGraphMethods
implements MethodInterceptor,
RepositoryProxyPostProcessor {
    public static final DefaultEntityGraphMethods INSTANCE = new DefaultEntityGraphMethods();
    private final DefaultMethodInvokingMethodInterceptor defaultMethodInvokingMethodInterceptor = new DefaultMethodInvokingMethodInterceptor();

    private DefaultEntityGraphMethods() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        RepositoryMethodInvocation methodInvocation = new RepositoryMethodInvocation(invocation);
        if (!this.isDefaultEntityGraphMethod(methodInvocation)) {
            return invocation.proceed();
        }
        return this.defaultMethodInvokingMethodInterceptor.invoke(invocation);
    }

    private boolean isDefaultEntityGraphMethod(RepositoryMethodInvocation invocation) {
        return invocation.repository() instanceof EntityGraphRepository && "defaultEntityGraph".equals(invocation.method().getName()) && invocation.arguments().length == 0;
    }

    public void postProcess(final ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addListener(new AdvisedSupportListener(){

            public void activated(AdvisedSupport advised) {
                factory.addAdvice(0, (Advice)DefaultEntityGraphMethods.this);
            }

            public void adviceChanged(AdvisedSupport advised) {
            }
        });
    }
}

