/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.repository.query.EntityGraphAwareJpaQueryMethodFactory;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQuerydslRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphSimpleJpaRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.support.RepositoryMethodEntityGraphExtractor;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;

public class EntityGraphJpaRepositoryFactory
extends JpaRepositoryFactory {
    public EntityGraphJpaRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.addRepositoryProxyPostProcessor(new RepositoryMethodEntityGraphExtractor(entityManager));
        this.setQueryMethodFactory(new EntityGraphAwareJpaQueryMethodFactory((QueryExtractor)PersistenceProvider.fromEntityManager((EntityManager)entityManager)));
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
            return EntityGraphQuerydslRepository.class;
        }
        return EntityGraphSimpleJpaRepository.class;
    }

    private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }
}

