/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.querydsl.jpa.JPQLQuery;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.NamedThreadLocal;

class CountQueryDetector
implements MethodInterceptor {
    private static final CountQueryDetector INSTANCE = new CountQueryDetector();
    private static final String FETCH_METHOD_NAME_PREFIX = "fetch";
    private static final NamedThreadLocal<Boolean> IS_COUNT_QUERY = new NamedThreadLocal("A thread local holding a boolean describing the fact that the current query is count query");

    private CountQueryDetector() {
    }

    static JPQLQuery<?> proxy(JPQLQuery<?> countQuery) {
        ProxyFactory proxyFactory = new ProxyFactory(countQuery);
        proxyFactory.addAdvice((Advice)INSTANCE);
        return (JPQLQuery)proxyFactory.getProxy();
    }

    static boolean isCountQuery() {
        return IS_COUNT_QUERY.get() != null && (Boolean)IS_COUNT_QUERY.get() != false;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getName().startsWith(FETCH_METHOD_NAME_PREFIX)) {
            IS_COUNT_QUERY.set((Object)true);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            IS_COUNT_QUERY.set((Object)false);
        }
    }
}

