/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.domain2;

import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphQueryHint;
import com.cosium.spring.data.jpa.entity.graph.domain2.EntityGraphType;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;

public class NamedEntityGraph
implements EntityGraph {
    private final EntityGraphType type;
    private final String name;

    public NamedEntityGraph(EntityGraphType type, String name) {
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
    }

    public static NamedEntityGraph loading(String name) {
        return new NamedEntityGraph(EntityGraphType.LOAD, name);
    }

    public static NamedEntityGraph fetching(String name) {
        return new NamedEntityGraph(EntityGraphType.FETCH, name);
    }

    @Override
    public Optional<EntityGraphQueryHint> buildQueryHint(EntityManager entityManager, Class<?> entityType) {
        return Optional.of(new EntityGraphQueryHint(this.type, entityManager.getEntityGraph(this.name)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedEntityGraph that = (NamedEntityGraph)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }
}

