/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphBean;
import java.util.Map;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;

class QueryHintsUtils {
    QueryHintsUtils() {
    }

    static boolean containsEntityGraph(Map<String, Object> queryHints) {
        return queryHints != null && (queryHints.containsKey(EntityGraph.EntityGraphType.FETCH.getKey()) || queryHints.containsKey(EntityGraph.EntityGraphType.LOAD.getKey()));
    }

    static void removeEntityGraphs(Map<String, Object> queryHints) {
        if (queryHints == null) {
            return;
        }
        queryHints.remove(EntityGraph.EntityGraphType.FETCH.getKey());
        queryHints.remove(EntityGraph.EntityGraphType.LOAD.getKey());
    }

    static Map<String, Object> buildQueryHints(EntityManager entityManager, EntityGraphBean entityGraph) {
        return Jpa21Utils.tryGetFetchGraphHints((EntityManager)entityManager, (JpaEntityGraph)entityGraph.getJpaEntityGraph(), entityGraph.getDomainClass());
    }
}

