/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphQuerydslRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.support.EntityGraphSimpleJpaRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.support.RepositoryMethodEntityGraphExtractor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.ReflectionUtils;

public class EntityGraphJpaRepositoryFactory
extends JpaRepositoryFactory {
    public EntityGraphJpaRepositoryFactory(EntityManager entityManager) {
        super(entityManager);
        this.addRepositoryProxyPostProcessor(new RepositoryMethodEntityGraphExtractor(entityManager));
    }

    private static void addEntityGraphToSpecialTypes() {
        EntityGraphJpaRepositoryFactory.addEntityGraphToSpecialTypes(Parameters.class, "TYPES");
        EntityGraphJpaRepositoryFactory.addEntityGraphToSpecialTypes(Parameter.class, "TYPES");
    }

    private static void addEntityGraphToSpecialTypes(Class<?> clazz, String fieldName) {
        try {
            Field field = ReflectionUtils.findField(clazz, (String)fieldName);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            ArrayList<Class<EntityGraph>> specialTypes = new ArrayList<Class<EntityGraph>>((List)field.get(null));
            specialTypes.add(EntityGraph.class);
            ReflectionUtils.setField((Field)field, null, specialTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
            return EntityGraphQuerydslRepository.class;
        }
        return EntityGraphSimpleJpaRepository.class;
    }

    private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    static {
        EntityGraphJpaRepositoryFactory.addEntityGraphToSpecialTypes();
    }
}

