/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.entity.graph.repository.support;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.springframework.core.ResolvableType;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;

class EntityGraphBean {
    private final JpaEntityGraph jpaEntityGraph;
    private final Class<?> domainClass;
    private final ResolvableType repositoryMethodReturnType;
    private final boolean optional;
    private final boolean primary;
    private final boolean valid;

    public EntityGraphBean(JpaEntityGraph jpaEntityGraph, Class<?> domainClass, ResolvableType repositoryMethodReturnType, boolean optional, boolean primary) {
        this.jpaEntityGraph = Objects.requireNonNull(jpaEntityGraph);
        this.domainClass = Objects.requireNonNull(domainClass);
        this.repositoryMethodReturnType = Objects.requireNonNull(repositoryMethodReturnType);
        this.optional = optional;
        this.primary = primary;
        this.valid = this.computeValidity();
    }

    private boolean computeValidity() {
        Class resolvedReturnType = this.repositoryMethodReturnType.resolve();
        if (Void.TYPE.equals(resolvedReturnType) || this.domainClass.isAssignableFrom(resolvedReturnType)) {
            return true;
        }
        for (Class genericType : this.repositoryMethodReturnType.resolveGenerics()) {
            if (!this.domainClass.isAssignableFrom(genericType)) continue;
            return true;
        }
        return false;
    }

    public JpaEntityGraph getJpaEntityGraph() {
        return this.jpaEntityGraph;
    }

    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jpaEntityGraph", (Object)this.jpaEntityGraph).add("domainClass", this.domainClass).add("repositoryMethodReturnType", (Object)this.repositoryMethodReturnType).add("optional", this.optional).toString();
    }
}

