/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.spring.data.jpa.graph.generator;

import com.cosium.spring.data.jpa.graph.generator.Composer;
import com.cosium.spring.data.jpa.graph.generator.EntityGraph;
import com.cosium.spring.data.jpa.graph.generator.EntityGraphClassName;
import com.cosium.spring.data.jpa.graph.generator.MetamodelAttribute;
import com.cosium.spring.data.jpa.graph.generator.MetamodelAttributeTarget;
import com.cosium.spring.data.jpa.graph.generator.NodeComposer;
import com.cosium.spring.data.jpa.graph.generator.RootComposer;
import com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.metamodel.StaticMetamodel;

public class MetamodelClass {
    private final Elements elements;
    private final Types types;
    private final TypeElement typeElement;

    public MetamodelClass(Elements elements, Types types, TypeElement typeElement) {
        this.elements = Objects.requireNonNull(elements);
        this.types = Objects.requireNonNull(types);
        this.typeElement = Objects.requireNonNull(typeElement);
    }

    public void writeEntityGraphTo(Filer filer) {
        try {
            this.doWriteEntityGraphTo(filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doWriteEntityGraphTo(Filer filer) throws IOException {
        StaticMetamodel staticMetamodel = this.typeElement.getAnnotation(StaticMetamodel.class);
        try {
            staticMetamodel.value();
            throw new RuntimeException("entityTypeElement.value() didn't throw !");
        }
        catch (MirroredTypeException e) {
            TypeElement entityTypeElement = (TypeElement)this.types.asElement(e.getTypeMirror());
            ClassName entityGraphClassName = new EntityGraphClassName(this.elements, entityTypeElement).toClassName();
            RootComposer rootComposer = new RootComposer(entityGraphClassName);
            NodeComposer nodeComposer = new NodeComposer();
            List<Composer> composers = Arrays.asList(rootComposer, nodeComposer);
            this.elements.getAllMembers(this.typeElement).stream().map(member -> MetamodelAttribute.parse(this.elements, this.types, member)).filter(Optional::isPresent).map(Optional::get).map(MetamodelAttribute::jpaEntityTarget).filter(Optional::isPresent).map(Optional::get).forEach(attribute -> composers.forEach(composer -> composer.addPath(this.elements, (MetamodelAttributeTarget)attribute)));
            new EntityGraph(entityGraphClassName, rootComposer, nodeComposer).writeTo(filer);
            return;
        }
    }
}

