/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.openid_connect.mock.server;

import io.vertx.core.http.HttpServerRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

class ClientBasicAuthentication {
    final String clientId;
    final String clientSecret;

    ClientBasicAuthentication(HttpServerRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        String base64BasicAuthenticationToken = authorizationHeader == null ? "" : authorizationHeader.substring("Basic ".length());
        String[] basicAuthenticationToken = new String(Base64.getDecoder().decode(base64BasicAuthenticationToken), StandardCharsets.UTF_8).split(":");
        if (basicAuthenticationToken.length != 2) {
            this.clientId = null;
            this.clientSecret = null;
        } else {
            this.clientId = basicAuthenticationToken[0];
            this.clientSecret = basicAuthenticationToken[1];
        }
    }

    boolean isComplete() {
        return this.clientId != null && this.clientSecret != null;
    }
}

