/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.response;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.coopsrc.xandroid.utils.LogUtils;
import java.io.IOException;
import retrofit2.Response;

public class ApiResponse<T> {
    public final int code;
    @Nullable
    public final T body;
    @Nullable
    public final String message;

    public ApiResponse(@NonNull Throwable throwable) {
        this.code = 500;
        this.body = null;
        this.message = throwable.getMessage();
    }

    public ApiResponse(@NonNull Response<T> response) {
        this.code = response.code();
        if (response.isSuccessful()) {
            this.body = response.body();
            this.message = response.message();
        } else {
            this.body = null;
            String errorMessage = null;
            if (response.errorBody() != null) {
                try {
                    errorMessage = response.errorBody().string();
                }
                catch (IOException e) {
                    LogUtils.e((Throwable)e, (String)"error while parsing response", (Object[])new Object[0]);
                }
            }
            if (errorMessage == null || errorMessage.trim().length() == 0) {
                errorMessage = response.message();
            }
            this.message = errorMessage;
        }
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }
}

