/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.adapter;

import androidx.lifecycle.LiveData;
import com.coopsrc.xandroid.http.response.ApiResponse;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;

public class LiveDataCallAdapter<R>
implements CallAdapter<R, LiveData<ApiResponse<R>>> {
    private final Type responseType;

    public LiveDataCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    @NotNull
    public Type responseType() {
        return this.responseType;
    }

    @NotNull
    public LiveData<ApiResponse<R>> adapt(final @NotNull Call<R> call) {
        return new LiveData<ApiResponse<R>>(){

            protected void onActive() {
                super.onActive();
                AtomicBoolean started = new AtomicBoolean(false);
                if (started.compareAndSet(false, true)) {
                    call.enqueue(new Callback<R>(){

                        public void onResponse(@NotNull Call<R> call, @NotNull Response<R> response) {
                            this.postValue(new ApiResponse(response));
                        }

                        public void onFailure(@NotNull Call<R> call, @NotNull Throwable throwable) {
                            this.postValue(new ApiResponse(throwable));
                        }
                    });
                }
            }
        };
    }
}

