/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.interceptor;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.coopsrc.xandroid.http.config.HttpConstants;
import com.coopsrc.xandroid.startup.ContextProvider;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/coopsrc/xandroid/http/interceptor/CacheControlInterceptor;", "Lokhttp3/Interceptor;", "()V", "getContext", "Landroid/content/Context;", "getMaxAge", "", "getMaxStale", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isNetworkReachable", "", "context", "http_release"})
public class CacheControlInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        CacheControl originalCacheControl = originalRequest.cacheControl();
        if (!TextUtils.isEmpty((CharSequence)originalCacheControl.toString())) {
            return chain.proceed(originalRequest);
        }
        if (!this.isNetworkReachable(this.getContext())) {
            originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
        }
        Response response = chain.proceed(originalRequest);
        String cacheControlValue = this.isNetworkReachable(this.getContext()) ? "public, max-age=" + this.getMaxAge() : "public, only-if-cached, max-stale=" + this.getMaxStale();
        response = response.newBuilder().header("Cache-Control", cacheControlValue).removeHeader("pragma").build();
        return response;
    }

    @NotNull
    protected Context getContext() {
        Context context = ContextProvider.getAppContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"ContextProvider.getAppContext()");
        return context;
    }

    protected long getMaxAge() {
        return HttpConstants.CACHE_MAX_AGE;
    }

    protected long getMaxStale() {
        return HttpConstants.CACHE_MAX_STALE;
    }

    protected synchronized boolean isNetworkReachable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        NetworkInfo current = cm.getActiveNetworkInfo();
        return current != null && current.isAvailable();
    }
}

