/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http;

import androidx.annotation.NonNull;
import com.coopsrc.xandroid.http.config.HttpClientConfig;
import com.coopsrc.xandroid.http.interceptor.BasicParamsInterceptor;
import com.coopsrc.xandroid.http.logging.HttpLogger;
import com.coopsrc.xandroid.http.monitor.MonitorInterceptor;
import com.coopsrc.xandroid.utils.LogUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager;", "", "()V", "createRetrofit", "Lretrofit2/Retrofit;", "clientConfig", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "newRetrofit", "BaseHttpClientConfig", "http_release"})
public final class RetrofitManager {
    public static final RetrofitManager INSTANCE;

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit() {
        LogUtils.i((String)"newRetrofit: ", (Object[])new Object[0]);
        return RetrofitManager.createRetrofit$default(INSTANCE, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull HttpClientConfig clientConfig) {
        Intrinsics.checkParameterIsNotNull((Object)clientConfig, (String)"clientConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{clientConfig.getPrimaryHost()});
        return INSTANCE.createRetrofit(clientConfig);
    }

    private final Retrofit createRetrofit(@NonNull HttpClientConfig clientConfig) {
        LogUtils.i((String)"createRetrofit: ", (Object[])new Object[]{clientConfig});
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        BasicParamsInterceptor.Builder basicParamsBuilder = new BasicParamsInterceptor.Builder();
        basicParamsBuilder.addQueryParams(clientConfig.getBasicQueryParams());
        basicParamsBuilder.addBodyParams(clientConfig.getBodyMapParams());
        basicParamsBuilder.addHeaderParams(clientConfig.getHeaderMapParams());
        httpClientBuilder.addInterceptor((Interceptor)basicParamsBuilder.build());
        for (Interceptor interceptor : clientConfig.getInterceptors()) {
            httpClientBuilder.addInterceptor(interceptor);
        }
        for (Interceptor interceptor : clientConfig.getNetworkInterceptors()) {
            httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        if (clientConfig.getTokenInterceptor() != null) {
            Interceptor interceptor = clientConfig.getTokenInterceptor();
            if (interceptor == null) {
                Intrinsics.throwNpe();
            }
            httpClientBuilder.addInterceptor(interceptor);
        }
        if (clientConfig.getTokenAuthenticator() != null) {
            Authenticator authenticator = clientConfig.getTokenAuthenticator();
            if (authenticator == null) {
                Intrinsics.throwNpe();
            }
            httpClientBuilder.authenticator(authenticator);
        }
        if (clientConfig.getDebugMonitorInterceptor$http_release() != null) {
            MonitorInterceptor monitorInterceptor = clientConfig.getDebugMonitorInterceptor$http_release();
            if (monitorInterceptor == null) {
                Intrinsics.throwNpe();
            }
            httpClientBuilder.addInterceptor((Interceptor)monitorInterceptor);
        }
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
        httpLoggingInterceptor.level(clientConfig.httpLogLevel());
        httpClientBuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        httpClientBuilder.cache(clientConfig.httpClientCache());
        httpClientBuilder.connectTimeout(clientConfig.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.writeTimeout(clientConfig.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.readTimeout(clientConfig.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.retryOnConnectionFailure(clientConfig.retryOnConnectionFailure());
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        retrofitBuilder.client(httpClientBuilder.build());
        retrofitBuilder.baseUrl(clientConfig.getPrimaryHost());
        for (CallAdapter.Factory callAdapterFactory : clientConfig.callAdapterFactories()) {
            retrofitBuilder.addCallAdapterFactory(callAdapterFactory);
        }
        for (Converter.Factory converterFactory : clientConfig.converterFactories()) {
            retrofitBuilder.addConverterFactory(converterFactory);
        }
        Retrofit retrofit = retrofitBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilder.build()");
        return retrofit;
    }

    static /* synthetic */ Retrofit createRetrofit$default(RetrofitManager retrofitManager, HttpClientConfig httpClientConfig, int n, Object object) {
        if ((n & 1) != 0) {
            httpClientConfig = new BaseHttpClientConfig();
        }
        return retrofitManager.createRetrofit(httpClientConfig);
    }

    private RetrofitManager() {
    }

    static {
        RetrofitManager retrofitManager;
        INSTANCE = retrofitManager = new RetrofitManager();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager$BaseHttpClientConfig;", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "()V", "http_release"})
    private static final class BaseHttpClientConfig
    extends HttpClientConfig {
    }
}

