/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.api;

import com.coopsrc.xandroid.http.RetrofitManager;
import com.coopsrc.xandroid.http.adapter.LiveDataCallAdapterFactory;
import com.coopsrc.xandroid.http.config.HttpClientConfig;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0014J\u001f\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0001\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J'\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u00028\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0004\u00a2\u0006\u0002\u0010\u0015J\r\u0010\u0017\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014R\u001c\u0010\u0004\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/coopsrc/xandroid/http/api/BaseApiProxy;", "T", "", "()V", "apiService", "getApiService", "()Ljava/lang/Object;", "setApiService", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "retrofit", "Lretrofit2/Retrofit;", "clientConfig", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "create", "S", "service", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "baseUrl", "", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "createApiService", "initApiService", "updateBaseUrl", "", "ClientConfig", "http_release"})
public abstract class BaseApiProxy<T> {
    private Retrofit retrofit = RetrofitManager.newRetrofit(this.clientConfig());
    private T apiService = this.initApiService();

    protected final T getApiService() {
        return this.apiService;
    }

    protected final void setApiService(T t) {
        this.apiService = t;
    }

    @NotNull
    protected HttpClientConfig clientConfig() {
        return new ClientConfig();
    }

    protected abstract T initApiService();

    protected final T createApiService(@NotNull Class<T> service) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return (T)this.retrofit.create(service);
    }

    public final <S> S create(@NotNull Class<S> service) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return (S)this.retrofit.create(service);
    }

    protected final T createApiService(@NotNull String baseUrl, @NotNull Class<T> service) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return (T)this.retrofit.newBuilder().baseUrl(baseUrl).build().create(service);
    }

    public final <S> S create(@NotNull String baseUrl, @NotNull Class<S> service) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        return (S)this.retrofit.newBuilder().baseUrl(baseUrl).build().create(service);
    }

    public final void updateBaseUrl(@NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Retrofit retrofit = this.retrofit.newBuilder().baseUrl(baseUrl).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofit.newBuilder().baseUrl(baseUrl).build()");
        this.retrofit = retrofit;
    }

    protected BaseApiProxy() {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/coopsrc/xandroid/http/api/BaseApiProxy$ClientConfig;", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "()V", "callAdapterFactories", "", "Lretrofit2/CallAdapter$Factory;", "converterFactories", "Lretrofit2/Converter$Factory;", "http_release"})
    protected static class ClientConfig
    extends HttpClientConfig {
        @Override
        @NotNull
        public Set<CallAdapter.Factory> callAdapterFactories() {
            return SetsKt.plus((Set)SetsKt.plus(super.callAdapterFactories(), (Object)RxJava2CallAdapterFactory.create()), (Object)((Object)LiveDataCallAdapterFactory.create()));
        }

        @Override
        @NotNull
        public Set<Converter.Factory> converterFactories() {
            return SetsKt.plus(super.converterFactories(), (Object)GsonConverterFactory.create());
        }
    }
}

