/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.api;

import androidx.annotation.NonNull;
import com.coopsrc.xandroid.http.RetrofitManager;
import com.coopsrc.xandroid.http.config.BasicParamsConfig;
import com.coopsrc.xandroid.http.config.HttpClientConfig;
import com.coopsrc.xandroid.http.config.ServerHostConfig;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public abstract class BaseApiProxy<T> {
    protected Retrofit mRetrofit = RetrofitManager.newRetrofit(this.serverHostConfig(), this.clientConfig(), this.basicParamsConfig());
    protected T mApiService = this.initApiService();

    protected BaseApiProxy() {
    }

    @NonNull
    protected HttpClientConfig clientConfig() {
        return new ClientConfig();
    }

    @NonNull
    protected abstract ServerHostConfig serverHostConfig();

    @NonNull
    protected BasicParamsConfig basicParamsConfig() {
        return new ParamsConfig();
    }

    protected abstract T initApiService();

    protected T createApiService(Class<T> service) {
        return (T)this.mRetrofit.create(service);
    }

    public <S> S create(Class<S> service) {
        return (S)this.mRetrofit.create(service);
    }

    protected T createApiService(String baseUrl, Class<T> service) {
        return (T)this.mRetrofit.newBuilder().baseUrl(baseUrl).build().create(service);
    }

    public <S> S create(String baseUrl, Class<S> service) {
        return (S)this.mRetrofit.newBuilder().baseUrl(baseUrl).build().create(service);
    }

    public void updateBaseUrl(String baseUrl) {
        this.mRetrofit = this.mRetrofit.newBuilder().baseUrl(baseUrl).build();
    }

    protected abstract class ServerConfig
    extends ServerHostConfig {
        protected ServerConfig() {
        }
    }

    protected class ParamsConfig
    extends BasicParamsConfig {
        protected ParamsConfig() {
        }
    }

    protected class ClientConfig
    extends HttpClientConfig {
        protected ClientConfig() {
        }

        @Override
        @NotNull
        public Set<CallAdapter.Factory> callAdapterFactories() {
            return super.callAdapterFactories();
        }

        @Override
        @NotNull
        public Set<Converter.Factory> converterFactories() {
            return super.converterFactories();
        }
    }
}

