/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http;

import androidx.annotation.NonNull;
import com.coopsrc.xandroid.http.config.BasicParamsConfig;
import com.coopsrc.xandroid.http.config.HttpClientConfig;
import com.coopsrc.xandroid.http.config.ServerHostConfig;
import com.coopsrc.xandroid.http.interceptor.BasicParamsInterceptor;
import com.coopsrc.xandroid.http.logging.HttpLogger;
import com.coopsrc.xandroid.utils.LogUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0003\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager;", "", "()V", "createRetrofit", "Lretrofit2/Retrofit;", "serverConfig", "Lcom/coopsrc/xandroid/http/config/ServerHostConfig;", "clientConfig", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "paramsConfig", "Lcom/coopsrc/xandroid/http/config/BasicParamsConfig;", "newRetrofit", "BaseHttpClientConfig", "BaseParamsConfig", "http_release"})
public final class RetrofitManager {
    public static final RetrofitManager INSTANCE;

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return INSTANCE.createRetrofit(serverConfig, new BaseHttpClientConfig(), new BaseParamsConfig());
    }

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig, @NonNull @NotNull BasicParamsConfig paramsConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkParameterIsNotNull((Object)paramsConfig, (String)"paramsConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return RetrofitManager.createRetrofit$default(INSTANCE, serverConfig, null, paramsConfig, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig, @NonNull @NotNull HttpClientConfig clientConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkParameterIsNotNull((Object)clientConfig, (String)"clientConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return RetrofitManager.createRetrofit$default(INSTANCE, serverConfig, clientConfig, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig, @NonNull @NotNull HttpClientConfig clientConfig, @NonNull @NotNull BasicParamsConfig paramsConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkParameterIsNotNull((Object)clientConfig, (String)"clientConfig");
        Intrinsics.checkParameterIsNotNull((Object)paramsConfig, (String)"paramsConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return INSTANCE.createRetrofit(serverConfig, clientConfig, paramsConfig);
    }

    private final Retrofit createRetrofit(@NonNull ServerHostConfig serverConfig, @NonNull HttpClientConfig clientConfig, @NonNull BasicParamsConfig paramsConfig) {
        LogUtils.i((String)"createRetrofit: ", (Object[])new Object[]{serverConfig});
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        BasicParamsInterceptor.Builder basicParamsBuilder = new BasicParamsInterceptor.Builder();
        basicParamsBuilder.addQueryParams(paramsConfig.getBasicQueryParams());
        basicParamsBuilder.addBodyParams(paramsConfig.getBodyMapParams());
        basicParamsBuilder.addHeaderParams(paramsConfig.getHeaderMapParams());
        httpClientBuilder.addInterceptor((Interceptor)basicParamsBuilder.build());
        for (Interceptor interceptor : paramsConfig.getInterceptors()) {
            httpClientBuilder.addInterceptor(interceptor);
        }
        for (Interceptor interceptor : paramsConfig.getNetworkInterceptors()) {
            httpClientBuilder.addNetworkInterceptor(interceptor);
        }
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
        httpLoggingInterceptor.level(HttpLoggingInterceptor.Level.BODY);
        httpClientBuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        if (clientConfig.httpClientCache() != null) {
            httpClientBuilder.cache(clientConfig.httpClientCache());
        }
        httpClientBuilder.connectTimeout(clientConfig.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.writeTimeout(clientConfig.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.readTimeout(clientConfig.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        httpClientBuilder.retryOnConnectionFailure(clientConfig.retryOnConnectionFailure());
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        retrofitBuilder.client(httpClientBuilder.build());
        retrofitBuilder.baseUrl(serverConfig.getPrimaryHost());
        for (CallAdapter.Factory callAdapterFactory : clientConfig.callAdapterFactories()) {
            retrofitBuilder.addCallAdapterFactory(callAdapterFactory);
        }
        for (Converter.Factory converterFactory : clientConfig.converterFactories()) {
            retrofitBuilder.addConverterFactory(converterFactory);
        }
        Retrofit retrofit = retrofitBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilder.build()");
        return retrofit;
    }

    static /* synthetic */ Retrofit createRetrofit$default(RetrofitManager retrofitManager, ServerHostConfig serverHostConfig, HttpClientConfig httpClientConfig, BasicParamsConfig basicParamsConfig, int n, Object object) {
        if ((n & 2) != 0) {
            httpClientConfig = new BaseHttpClientConfig();
        }
        if ((n & 4) != 0) {
            basicParamsConfig = new BaseParamsConfig();
        }
        return retrofitManager.createRetrofit(serverHostConfig, httpClientConfig, basicParamsConfig);
    }

    private RetrofitManager() {
    }

    static {
        RetrofitManager retrofitManager;
        INSTANCE = retrofitManager = new RetrofitManager();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager$BaseHttpClientConfig;", "Lcom/coopsrc/xandroid/http/config/HttpClientConfig;", "()V", "http_release"})
    private static final class BaseHttpClientConfig
    extends HttpClientConfig {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager$BaseParamsConfig;", "Lcom/coopsrc/xandroid/http/config/BasicParamsConfig;", "()V", "http_release"})
    private static final class BaseParamsConfig
    extends BasicParamsConfig {
    }
}

