package com.coopsrc.xandroid.http.config

import okhttp3.Cache
import retrofit2.CallAdapter
import retrofit2.Converter

internal interface IHttpClientConfig {

    fun httpClientCache(): Cache?

    fun connectTimeoutMillis(): Long

    fun writeTimeoutMillis(): Long

    fun readTimeoutMillis(): Long

    fun retryOnConnectionFailure(): Boolean

    fun callAdapterFactories(): Set<CallAdapter.Factory>

    fun converterFactories(): Set<Converter.Factory>
}
