/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http;

import androidx.annotation.NonNull;
import com.coopsrc.xandroid.http.BasicParamsConfig;
import com.coopsrc.xandroid.http.ServerHostConfig;
import com.coopsrc.xandroid.http.interceptor.BasicParamsInterceptor;
import com.coopsrc.xandroid.http.logging.HttpLogger;
import com.coopsrc.xandroid.utils.LogUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u001c\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager;", "", "()V", "DEFAULT_CONN_TIME_OUT", "", "DEFAULT_READ_TIME_OUT", "DEFAULT_WRITE_TIME_OUT", "createRetrofit", "Lretrofit2/Retrofit;", "serverConfig", "Lcom/coopsrc/xandroid/http/ServerHostConfig;", "paramsConfig", "Lcom/coopsrc/xandroid/http/BasicParamsConfig;", "newRetrofit", "BaseParamsConfig", "http_release"})
public final class RetrofitManager {
    private static final long DEFAULT_CONN_TIME_OUT;
    private static final long DEFAULT_READ_TIME_OUT;
    private static final long DEFAULT_WRITE_TIME_OUT;
    public static final RetrofitManager INSTANCE;

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return RetrofitManager.newRetrofit(serverConfig, new BaseParamsConfig());
    }

    @JvmStatic
    @NotNull
    public static final Retrofit newRetrofit(@NonNull @NotNull ServerHostConfig serverConfig, @NonNull @NotNull BasicParamsConfig paramsConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkParameterIsNotNull((Object)paramsConfig, (String)"paramsConfig");
        LogUtils.i((String)"newRetrofit: %s", (Object[])new Object[]{serverConfig.getPrimaryHost()});
        return INSTANCE.createRetrofit(serverConfig, paramsConfig);
    }

    private final Retrofit createRetrofit(@NonNull ServerHostConfig serverConfig, @NonNull BasicParamsConfig paramsConfig) {
        LogUtils.i((String)"createRetrofit: ", (Object[])new Object[]{serverConfig});
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        BasicParamsInterceptor.Builder basicParamsBuilder = new BasicParamsInterceptor.Builder();
        basicParamsBuilder.addQueryParams(paramsConfig.getBasicQueryParams());
        basicParamsBuilder.addBodyParams(paramsConfig.getBodyMapParams());
        basicParamsBuilder.addHeaderParams(paramsConfig.getHeaderMapParams());
        httpClientBuilder.addInterceptor((Interceptor)basicParamsBuilder.build());
        for (Interceptor interceptor : paramsConfig.getCustomInterceptors()) {
            httpClientBuilder.addInterceptor(interceptor);
        }
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger());
        httpLoggingInterceptor.level(HttpLoggingInterceptor.Level.BODY);
        httpClientBuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        if (paramsConfig.getCache() != null) {
            httpClientBuilder.cache(paramsConfig.getCache());
        }
        httpClientBuilder.connectTimeout(DEFAULT_CONN_TIME_OUT, TimeUnit.MILLISECONDS);
        httpClientBuilder.writeTimeout(DEFAULT_READ_TIME_OUT, TimeUnit.MILLISECONDS);
        httpClientBuilder.readTimeout(DEFAULT_WRITE_TIME_OUT, TimeUnit.MILLISECONDS);
        httpClientBuilder.retryOnConnectionFailure(true);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        retrofitBuilder.client(httpClientBuilder.build());
        retrofitBuilder.baseUrl(serverConfig.getPrimaryHost());
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        retrofitBuilder.addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        Retrofit retrofit = retrofitBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilder.build()");
        return retrofit;
    }

    private RetrofitManager() {
    }

    static {
        RetrofitManager retrofitManager;
        INSTANCE = retrofitManager = new RetrofitManager();
        DEFAULT_CONN_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);
        DEFAULT_READ_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);
        DEFAULT_WRITE_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/coopsrc/xandroid/http/RetrofitManager$BaseParamsConfig;", "Lcom/coopsrc/xandroid/http/BasicParamsConfig;", "()V", "http_release"})
    private static final class BaseParamsConfig
    extends BasicParamsConfig {
    }
}

