/*
 * Decompiled with CFR 0.152.
 */
package com.coopsrc.xandroid.http.api;

import androidx.annotation.NonNull;
import com.coopsrc.xandroid.http.BasicParamsConfig;
import com.coopsrc.xandroid.http.RetrofitManager;
import com.coopsrc.xandroid.http.ServerHostConfig;
import retrofit2.Retrofit;

public abstract class BaseApiProxy<T> {
    protected Retrofit mRetrofit = RetrofitManager.newRetrofit(this.serverHostConfig(), this.basicParamsConfig());
    protected T mApiService = this.initApiService();

    protected BaseApiProxy() {
    }

    @NonNull
    protected abstract ServerHostConfig serverHostConfig();

    protected BasicParamsConfig basicParamsConfig() {
        return new BasicParamsConfig(){};
    }

    protected abstract T initApiService();

    public T createApiService(Class<T> service) {
        return (T)this.mRetrofit.create(service);
    }

    public T createApiService(String baseUrl, Class<T> service) {
        return (T)this.mRetrofit.newBuilder().baseUrl(baseUrl).build().create(service);
    }

    public void updateBaseUrl(String baseUrl) {
        this.mRetrofit = this.mRetrofit.newBuilder().baseUrl(baseUrl).build();
    }
}

