/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.JenkinsPluginException;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.Project;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestCase;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.protocol.Protocol;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteService {
    private String serverUrl;
    private HttpClient httpClient;
    private HttpState httpState;
    private boolean bHttps;
    private int port;
    private String host;
    private String protocol;
    private String authority;
    private String path;
    private boolean bAssembleXsl;
    private boolean bAuthenticated;
    private String userId;
    private String password;
    List<Project> projectList;
    private static final String projectListExpression = "/admin/projects/project";
    private static final String projectInforExpression = "/admin/project";
    private static final String projectInforConnectorExp = "/admin/project/connector";
    private static final String projectInforSequenceExp = "/admin/project/sequence";
    private static final String testcaseFromCurrentNodeExp = ".//testcase";
    private static final String transFromCurrentNodeExp = ".//transaction";
    private static final String varFromCurrentNodeExp = ".//variable";

    public RemoteService() {
        this.serverUrl = "www.convertigo.com";
        this.protocol = "http";
        this.port = 80;
    }

    public RemoteService(String serverUrl, String userId, String password) throws JenkinsPluginException {
        this.serverUrl = serverUrl;
        this.httpClient = new HttpClient();
        try {
            URL url = new URL(serverUrl);
            this.protocol = url.getProtocol();
            this.authority = url.getAuthority();
            this.host = url.getHost();
            this.path = url.getPath();
            this.bHttps = "https".equals(url.getProtocol());
            this.bAssembleXsl = false;
            this.bAuthenticated = false;
            this.port = url.getPort() == -1 ? (this.bHttps ? 443 : 80) : url.getPort();
            this.userId = userId;
            this.password = password;
        }
        catch (MalformedURLException e) {
            throw new JenkinsPluginException("The deployment server is not valid: " + serverUrl + "\n" + e.getMessage());
        }
    }

    public void login() throws JenkinsPluginException {
        block17: {
            String loginServiceURL = this.protocol + "://" + this.authority + this.path + "/admin/services/engine.Authenticate";
            PostMethod loginMethod = null;
            try {
                if (this.userId.isEmpty()) {
                    throw new JenkinsPluginException("Unable to connect to the deployment server: \"Server administrator\" field is empty.");
                }
                if (this.password.isEmpty()) {
                    throw new JenkinsPluginException("Unable to connect to the deployment server: \"Password\" field is empty.");
                }
                this.httpState = this.httpState == null ? new HttpState() : this.httpState;
                this.httpClient.setState(this.httpState);
                loginMethod = new PostMethod(loginServiceURL);
                loginMethod.addParameter("authType", "login");
                loginMethod.addParameter("authUserName", this.userId);
                loginMethod.addParameter("authPassword", this.password);
                int returnCode = this.httpClient.executeMethod((HttpMethod)loginMethod);
                String httpResponse = loginMethod.getResponseBodyAsString();
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        if (nodeList.getLength() != 0) {
                            throw new JenkinsPluginException("Unable to connect to the deployment server: wrong username or password.");
                        }
                        this.bAuthenticated = true;
                        break block17;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse the deployment server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the deployment server login.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo server login.\nCause: " + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new JenkinsPluginException("Unable to find the Convertigo server (unknown host): " + e.getMessage());
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.indexOf("unable to find valid certification path") != -1) {
                    throw new JenkinsPluginException("The SSL certificate of the Convertigo server is not trusted.\nPlease check the 'Trust all certificates' checkbox.");
                }
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (loginMethod != null) {
                    loginMethod.releaseConnection();
                }
            }
        }
    }

    public Project getProjectInfo(String projectName) throws JenkinsPluginException {
        Project project;
        block16: {
            this.login();
            project = new Project(projectName);
            String projectInfoUrl = this.protocol + "://" + this.authority + this.path + "/admin/services/projects.GetTestPlatform";
            PostMethod getProjectInfoMethod = null;
            try {
                getProjectInfoMethod = new PostMethod(projectInfoUrl);
                getProjectInfoMethod.setParameter("projectName", projectName);
                int returnCode = this.httpClient.executeMethod((HttpMethod)getProjectInfoMethod);
                String httpResponse = getProjectInfoMethod.getResponseBodyAsString();
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        if (nodeList.getLength() != 0) {
                            throw new JenkinsPluginException("Unable to parse response of GetTestPlatform of project " + projectName);
                        }
                        this.bAuthenticated = true;
                        this.parseGetTestPlaformXml(domResponse, project);
                        break block16;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse the deployment server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the deployment server login.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (XPathExpressionException e) {
                        throw new JenkinsPluginException("fail to find list of Projects " + e.getMessage());
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo server login.\nCause: " + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new JenkinsPluginException("Unable to find the Convertigo server (unknown host): " + e.getMessage());
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.indexOf("unable to find valid certification path") != -1) {
                    throw new JenkinsPluginException("The SSL certificate of the Convertigo server is not trusted.\nPlease check the 'Trust all certificates' checkbox.");
                }
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (getProjectInfoMethod != null) {
                    getProjectInfoMethod.releaseConnection();
                }
            }
        }
        return project;
    }

    public List<Project> getListProjects() throws JenkinsPluginException {
        List<Project> projectlist;
        block16: {
            this.login();
            projectlist = null;
            String projectListUrl = this.protocol + "://" + this.authority + this.path + "/admin/services/projects.List";
            GetMethod getListMethod = null;
            try {
                getListMethod = new GetMethod(projectListUrl);
                int returnCode = this.httpClient.executeMethod((HttpMethod)getListMethod);
                String httpResponse = getListMethod.getResponseBodyAsString();
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        if (nodeList.getLength() != 0) {
                            throw new JenkinsPluginException("Unable to connect to the deployment server: wrong username or password.");
                        }
                        this.bAuthenticated = true;
                        projectlist = this.fillProjectList(domResponse);
                        break block16;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse the deployment server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the deployment server login.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (XPathExpressionException e) {
                        throw new JenkinsPluginException("fail to find list of Projects " + e.getMessage());
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo server login.\nCause: " + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new JenkinsPluginException("Unable to find the Convertigo server (unknown host): " + e.getMessage());
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.indexOf("unable to find valid certification path") != -1) {
                    throw new JenkinsPluginException("The SSL certificate of the Convertigo server is not trusted.\nPlease check the 'Trust all certificates' checkbox.");
                }
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (getListMethod != null) {
                    getListMethod.releaseConnection();
                }
            }
        }
        return projectlist;
    }

    String executeTestCase(TestCase testcase) throws JenkinsPluginException {
        String strResponse;
        block16: {
            strResponse = null;
            this.login();
            String exeTestCaseUrl = null;
            exeTestCaseUrl = !"".equalsIgnoreCase(testcase.getUrl()) ? testcase.getUrl() : this.serverUrl + "/projects/" + testcase.getProjectname() + TestCaseUrl.XML.endTail();
            GetMethod exeTestCaseMethod = null;
            try {
                NameValuePair[] QueryStringArray;
                exeTestCaseMethod = new GetMethod(exeTestCaseUrl);
                if (testcase.getType() != null && testcase.getType().equals("connector")) {
                    QueryStringArray = new NameValuePair[]{new NameValuePair("__connector", testcase.getTypeName()), new NameValuePair("__transaction", testcase.getTransaction()), new NameValuePair("__testcase", testcase.getName())};
                    exeTestCaseMethod.setQueryString(QueryStringArray);
                } else {
                    QueryStringArray = new NameValuePair[]{new NameValuePair("__sequence", testcase.getTypeName()), new NameValuePair("__testcase", testcase.getName())};
                    exeTestCaseMethod.setQueryString(QueryStringArray);
                }
                int returnCode = this.httpClient.executeMethod((HttpMethod)exeTestCaseMethod);
                String httpResponse = exeTestCaseMethod.getResponseBodyAsString();
                Document domResponse = null;
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        strResponse = httpResponse;
                        break block16;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the deployment server login.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo server login.\nCause: " + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new JenkinsPluginException("Unable to find the Convertigo server (unknown host): " + e.getMessage());
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.indexOf("unable to find valid certification path") != -1) {
                    throw new JenkinsPluginException("The SSL certificate of the Convertigo server is not trusted.\nPlease check the 'Trust all certificates' checkbox.");
                }
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (exeTestCaseMethod != null) {
                    exeTestCaseMethod.releaseConnection();
                }
            }
        }
        return strResponse;
    }

    private void decodeResponseError(String httpResponse) throws JenkinsPluginException {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
            domResponse.normalize();
            NodeList nodeList = domResponse.getElementsByTagName("error");
            if (nodeList.getLength() != 0) {
                Element errorNode = (Element)nodeList.item(0);
                Element errorMessage = (Element)errorNode.getElementsByTagName("message").item(0);
                Element exceptionName = (Element)errorNode.getElementsByTagName("exception").item(0);
                Element stackTrace = (Element)errorNode.getElementsByTagName("stacktrace").item(0);
                throw new JenkinsPluginException(errorMessage.getTextContent(), exceptionName == null ? "" : exceptionName.getTextContent(), stackTrace == null ? "" : stackTrace.getTextContent());
            }
        }
        catch (ParserConfigurationException e) {
            throw new JenkinsPluginException("Unable to parse the deployment server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
        }
        catch (IOException e) {
            throw new JenkinsPluginException("An unexpected error has occured during the Convertigo Project deployment.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
        }
        catch (SAXException e) {
            throw new JenkinsPluginException("Unable to parse the Deployment server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
        }
    }

    public void checkAuthentication() throws JenkinsPluginException {
        block16: {
            String checkAuthServiceURL = this.protocol + "://" + this.authority + this.path + "/admin/services/engine.CheckAuthentication";
            PostMethod checkAuthMethod = null;
            try {
                checkAuthMethod = new PostMethod(checkAuthServiceURL);
                int returnCode = this.httpClient.executeMethod((HttpMethod)checkAuthMethod);
                String httpResponse = checkAuthMethod.getResponseBodyAsString();
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        if (nodeList.getLength() != 0) {
                            throw new JenkinsPluginException("Unable to check Authentication with user id " + this.userId);
                        }
                        NodeList nodelist = domResponse.getElementsByTagName("authenticated");
                        if (nodelist.getLength() != 1) {
                            throw new JenkinsPluginException("Unable to check Authentication with user id " + this.userId);
                        }
                        Node node = nodeList.item(0);
                        break block16;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse the deployment server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the deployment server login.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo server login.\nCause: " + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new JenkinsPluginException("Unable to find the Convertigo server (unknown host): " + e.getMessage());
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message.indexOf("unable to find valid certification path") != -1) {
                    throw new JenkinsPluginException("The SSL certificate of the Convertigo server is not trusted.\nPlease check the 'Trust all certificates' checkbox.");
                }
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (checkAuthMethod != null) {
                    checkAuthMethod.releaseConnection();
                }
            }
        }
    }

    List<Project> fillProjectList(Document xmlDocument) throws XPathExpressionException {
        ArrayList<Project> list = new ArrayList<Project>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile(projectListExpression).evaluate(xmlDocument, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String name = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
            String comment = nodeList.item(i).getAttributes().getNamedItem("comment").getNodeValue();
            String deployDate = nodeList.item(i).getAttributes().getNamedItem("deployDate").getNodeValue();
            String exported = nodeList.item(i).getAttributes().getNamedItem("exported").getNodeValue();
            String version = nodeList.item(i).getAttributes().getNamedItem("version").getNodeValue();
            Project Project2 = new Project(name, comment, deployDate, exported, version);
            list.add(Project2);
        }
        return list;
    }

    public List<TestCase> getTestCaseListByProject(Project project) throws JenkinsPluginException {
        return project.getTestcaseList();
    }

    void parseGetTestPlaformXml(Document xmlDocument, Project project) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node projectInfo = (Node)xPath.compile(projectInforExpression).evaluate(xmlDocument, XPathConstants.NODE);
        String projectName = projectInfo.getAttributes().getNamedItem("name").getNodeValue();
        String projectVersion = projectInfo.getAttributes().getNamedItem("version").getNodeValue();
        String projectComment = projectInfo.getAttributes().getNamedItem("comment").getNodeValue();
        project.setComment(projectComment);
        project.setName(projectName);
        project.setVersion(projectVersion);
        String url = this.protocol + "://" + this.authority + this.path + "/projects/" + projectName + TestCaseUrl.XML.endTail();
        NodeList connectorList = (NodeList)xPath.compile(projectInforConnectorExp).evaluate(xmlDocument, XPathConstants.NODESET);
        for (int i = 0; i < connectorList.getLength(); ++i) {
            Node connector = connectorList.item(i);
            String connectorName = connector.getAttributes().getNamedItem("name").getNodeValue();
            NodeList transactionList = (NodeList)xPath.compile(transFromCurrentNodeExp).evaluate(connector, XPathConstants.NODESET);
            for (int j = 0; j < transactionList.getLength(); ++j) {
                Node transaction = transactionList.item(j);
                String transactionName = transaction.getAttributes().getNamedItem("name").getNodeValue();
                NodeList testcaseList = (NodeList)xPath.compile(testcaseFromCurrentNodeExp).evaluate(transaction, XPathConstants.NODESET);
                for (int z = 0; z < testcaseList.getLength(); ++z) {
                    Node testcaseNd = testcaseList.item(z);
                    String testcaseName = testcaseNd.getAttributes().getNamedItem("name").getNodeValue();
                    TestCase testcase = new TestCase();
                    testcase.setName(testcaseName);
                    testcase.setTransaction(transactionName);
                    testcase.setType("connector");
                    testcase.setTypeName(connectorName);
                    testcase.setUrl(url);
                    project.addTestCase(testcase);
                }
            }
        }
        NodeList sequenceList = (NodeList)xPath.compile(projectInforSequenceExp).evaluate(xmlDocument, XPathConstants.NODESET);
        for (int i = 0; i < sequenceList.getLength(); ++i) {
            Node sequence = sequenceList.item(i);
            String sequenceName = sequence.getAttributes().getNamedItem("name").getNodeValue();
            NodeList testcaseList = (NodeList)xPath.compile(testcaseFromCurrentNodeExp).evaluate(sequence, XPathConstants.NODESET);
            for (int z = 0; z < testcaseList.getLength(); ++z) {
                Node testcaseNd = testcaseList.item(z);
                String testcaseName = testcaseNd.getAttributes().getNamedItem("name").getNodeValue();
                TestCase testcase = new TestCase();
                testcase.setName(testcaseName);
                testcase.setType("sequence");
                testcase.setTypeName(sequenceName);
                testcase.setUrl(url);
                project.addTestCase(testcase);
            }
        }
    }

    public void deployArchive(File fileUpload) throws JenkinsPluginException {
        block15: {
            String deployServiceURL = this.protocol + "://" + this.authority + this.path + "/admin/services/projects.Deploy?bAssembleXsl=" + this.bAssembleXsl;
            PostMethod deployMethod = null;
            try {
                deployMethod = new PostMethod(deployServiceURL);
                Part[] parts = new Part[]{new FilePart(fileUpload.getName(), fileUpload)};
                deployMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, deployMethod.getParams()));
                int returnCode = this.httpClient.executeMethod((HttpMethod)deployMethod);
                String httpResponse = deployMethod.getResponseBodyAsString();
                if (returnCode == 200) {
                    try {
                        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document domResponse = parser.parse(new InputSource(new StringReader(httpResponse)));
                        domResponse.normalize();
                        NodeList nodeList = domResponse.getElementsByTagName("error");
                        if (nodeList.getLength() != 0) {
                            Element errorNode = (Element)nodeList.item(0);
                            Element errorMessage = (Element)errorNode.getElementsByTagName("message").item(0);
                            Element exceptionName = (Element)errorNode.getElementsByTagName("exception").item(0);
                            Element stackTrace = (Element)errorNode.getElementsByTagName("stacktrace").item(0);
                            if (errorMessage != null) {
                                throw new JenkinsPluginException(errorMessage.getTextContent(), exceptionName.getTextContent(), stackTrace.getTextContent());
                            }
                            throw new JenkinsPluginException("An unexpected error has occured during the Convertigo project deployment: \nBody content: \n\n");
                        }
                        break block15;
                    }
                    catch (ParserConfigurationException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: \n" + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                    catch (IOException e) {
                        throw new JenkinsPluginException("An unexpected error has occured during the Convertigo project deployment.\n(IOException) " + e.getMessage() + "\n" + "Received response: " + httpResponse, e);
                    }
                    catch (SAXException e) {
                        throw new JenkinsPluginException("Unable to parse the Convertigo server response: " + e.getMessage() + ".\n" + "Received response: " + httpResponse);
                    }
                }
                this.decodeResponseError(httpResponse);
            }
            catch (HttpException e) {
                throw new JenkinsPluginException("An unexpected error has occured during the Convertigo project deployment.\nCause: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(IOException) " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new JenkinsPluginException("Unable to reach the Convertigo server: \n(Exception) " + e.getMessage(), e);
            }
            finally {
                Protocol.unregisterProtocol((String)"https");
                if (deployMethod != null) {
                    deployMethod.releaseConnection();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            String url = "http://localhost:18080/convertigo";
            RemoteService rs = new RemoteService(url, "admin", "admin");
            Project project = rs.getProjectInfo("sampleMobileMobTV");
            List<TestCase> testcase = rs.getTestCaseListByProject(project);
            System.out.printf(rs.executeTestCase(testcase.get(6)), new Object[0]);
            boolean a = false;
            boolean bl = false;
        }
        catch (JenkinsPluginException e) {
            e.printStackTrace();
        }
    }

    public static enum TestCaseUrl {
        C80("/index.html"),
        XML("/.pxml?"),
        JSON("/.json");

        private final String tailend;

        private TestCaseUrl(String tail) {
            this.tailend = tail;
        }

        public String endTail() {
            return this.tailend;
        }
    }
}

