/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class Project {
    private String name;
    private String comment;
    private String deployDate;
    private String exported;
    private String version;
    private List<TestCase> testcaseList;

    public Project() {
        this.name = "";
        this.comment = "";
        this.deployDate = "";
        this.exported = "";
        this.version = "";
        this.testcaseList = new ArrayList<TestCase>();
    }

    @DataBoundConstructor
    public Project(String name, String comment, String deployDate, String exported, String version) {
        this.name = name;
        this.comment = comment;
        this.deployDate = deployDate;
        this.exported = exported;
        this.version = version;
        this.testcaseList = new ArrayList<TestCase>();
    }

    public Project(String name) {
        this.name = name;
        this.comment = "";
        this.deployDate = "";
        this.exported = "";
        this.version = "";
        this.testcaseList = new ArrayList<TestCase>();
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDeployDate() {
        return this.deployDate;
    }

    public String getExported() {
        return this.exported;
    }

    public String getVersion() {
        return this.version;
    }

    public void addTestCase(TestCase testcase) {
        if (this.testcaseList != null) {
            this.testcaseList.add(testcase);
        }
    }

    public TestCase createTestCase() {
        return new TestCase();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDeployDate(String deployDate) {
        this.deployDate = deployDate;
    }

    public void setExported(String exported) {
        this.exported = exported;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<TestCase> getTestcaseList() {
        return this.testcaseList;
    }

    public void setTestcaseList(List<TestCase> testcaseList) {
        this.testcaseList = testcaseList;
    }

    public void addTestcaseList(List<TestCase> testcaseList) {
        if (testcaseList != null && testcaseList.size() != 0) {
            this.testcaseList.addAll(testcaseList);
        }
    }

    public static Project findProjectByprojectname(List<Project> projectlist, String projectname) {
        Project project = null;
        for (Project item : projectlist) {
            if (projectname == null || !projectname.equals(item.getName())) continue;
            project = item;
        }
        return project;
    }
}

