/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.JenkinsPluginException;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.TestCase;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestResultAnalyzer {
    private static final String syntaxAsOk = "assert ok";
    private static final String syntaxAsNok = "assert nok";
    private static final String messsageErr = "error";
    private static final String messageErrType = "error";
    List<String> listAssertOk;
    List<String> listAssertNok = new ArrayList<String>();
    Map<String, ReturnType> mapAssertOk;
    Map<String, ReturnType> mapAssertNok;

    public TestResultAnalyzer() {
        this.listAssertOk = new ArrayList<String>();
        this.mapAssertOk = new HashMap<String, ReturnType>();
        this.mapAssertNok = new HashMap<String, ReturnType>();
    }

    public void addToListAssertOkh(String xpathline) {
        if (this.listAssertOk != null) {
            this.listAssertOk.add(xpathline);
        } else {
            this.listAssertOk = new ArrayList<String>();
        }
    }

    public void addToListAssertNok(String xpathline) {
        if (this.listAssertNok != null) {
            this.listAssertNok.add(xpathline);
        } else {
            this.listAssertNok = new ArrayList<String>();
        }
    }

    public ReturnType evaluateXpath(String xpathline, Document doc) {
        XPathExpression expr;
        ReturnType returnType = ReturnType.SYNTAX_OK;
        String exprXpath = xpathline;
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            expr = xpath.compile(exprXpath);
        }
        catch (XPathExpressionException e) {
            returnType = ReturnType.SYNTAX_NOK;
            return returnType;
        }
        if (doc != null) {
            try {
                NodeList result = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                returnType = result.getLength() > 0 ? ReturnType.FOUND : ReturnType.NOT_FOUND;
            }
            catch (XPathExpressionException e) {
                returnType = ReturnType.NOT_FOUND;
                e.printStackTrace();
            }
        }
        return returnType;
    }

    public void evaluateXpaths(AssertType type, List<String> xpathlines, Document doc) {
        block5: {
            block4: {
                if (type != AssertType.OK) break block4;
                for (int i = 0; i < xpathlines.size(); ++i) {
                    String exprXpath = xpathlines.get(i);
                    ReturnType returnType = this.evaluateXpath(exprXpath, doc);
                    if (this.mapAssertOk != null) {
                        this.mapAssertOk.put(exprXpath, returnType);
                        continue;
                    }
                    this.mapAssertOk = new HashMap<String, ReturnType>();
                    this.mapAssertOk.put(exprXpath, returnType);
                }
                break block5;
            }
            if (type != AssertType.NOK) break block5;
            for (int i = 0; i < xpathlines.size(); ++i) {
                String exprXpath = xpathlines.get(i);
                ReturnType returnType = this.evaluateXpath(exprXpath, doc);
                if (this.mapAssertNok != null) {
                    this.mapAssertNok.put(exprXpath, returnType);
                    continue;
                }
                this.mapAssertNok = new HashMap<String, ReturnType>();
                this.mapAssertNok.put(exprXpath, returnType);
            }
        }
    }

    public String displayEvaluateResult(String xpaths, String text) throws JenkinsPluginException {
        StringBuilder evaluateResultB = new StringBuilder();
        Document doc = null;
        if (text != null && !text.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(new InputSource(new StringReader(text)));
            }
            catch (Exception e) {
                throw new JenkinsPluginException("Unable to parse this TestCase response \n" + e.getMessage() + "\n");
            }
        }
        this.listAssertOk = this.getListAssertOk(xpaths);
        if (!this.listAssertOk.isEmpty()) {
            this.evaluateXpaths(AssertType.OK, this.listAssertOk, doc);
            for (Map.Entry<String, ReturnType> entry : this.mapAssertOk.entrySet()) {
                evaluateResultB.append(entry.getKey()).append("  ").append((Object)entry.getValue()).append("\n");
            }
        }
        this.listAssertNok = this.getListAssertNok(xpaths);
        if (!this.listAssertNok.isEmpty()) {
            this.evaluateXpaths(AssertType.NOK, this.listAssertNok, doc);
            for (Map.Entry<String, ReturnType> entry : this.mapAssertNok.entrySet()) {
                ReturnType rt = entry.getValue();
                evaluateResultB.append(entry.getKey()).append("  ").append(rt.getMessage()).append("\n");
            }
        }
        return evaluateResultB.toString();
    }

    public List<String> xmlAsserNokEvaluateResult(String xpaths, String text) throws JenkinsPluginException {
        ArrayList<String> responseList = new ArrayList<String>();
        Document doc = null;
        if (text != null && !text.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(new InputSource(new StringReader(text)));
            }
            catch (Exception e) {
                throw new JenkinsPluginException("Unable to parse this TestCase response \n" + e.getMessage() + "\n");
            }
        }
        this.listAssertNok = this.getListAssertNok(xpaths);
        if (!this.listAssertNok.isEmpty()) {
            this.evaluateXpaths(AssertType.NOK, this.listAssertNok, doc);
            for (Map.Entry<String, ReturnType> entry : this.mapAssertNok.entrySet()) {
                ReturnType rt = entry.getValue();
                if (rt == ReturnType.NOT_FOUND) continue;
                responseList.add(entry.getKey() + " " + rt.getMessage() + "\n");
            }
        }
        return responseList;
    }

    public List<String> xmlAsserOkEvaluateResult(String xpaths, String text) throws JenkinsPluginException {
        ArrayList<String> responseList = new ArrayList<String>();
        Document doc = null;
        if (text != null && !text.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(new InputSource(new StringReader(text)));
            }
            catch (Exception e) {
                throw new JenkinsPluginException("Unable to parse this TestCase response \n" + e.getMessage() + "\n");
            }
        }
        this.listAssertOk = this.getListAssertOk(xpaths);
        if (!this.listAssertOk.isEmpty()) {
            this.evaluateXpaths(AssertType.OK, this.listAssertOk, doc);
            for (Map.Entry<String, ReturnType> entry : this.mapAssertOk.entrySet()) {
                ReturnType rt = entry.getValue();
                if (rt == ReturnType.FOUND) continue;
                responseList.add(entry.getKey() + " " + rt.getMessage() + "\n");
            }
        }
        return responseList;
    }

    public List<String> displayAsserOkEvaluateResult(String xpaths, String text) throws JenkinsPluginException {
        StringBuilder evaluateResultB = new StringBuilder();
        Document doc = null;
        if (text != null && !text.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(new InputSource(new StringReader(text)));
            }
            catch (Exception e) {
                throw new JenkinsPluginException("Unable to parse this TestCase response \n" + e.getMessage() + "\n");
            }
        }
        this.listAssertOk = this.getListAssertOk(xpaths);
        if (!this.listAssertOk.isEmpty()) {
            this.evaluateXpaths(AssertType.OK, this.listAssertOk, doc);
            for (Map.Entry<String, ReturnType> entry : this.mapAssertOk.entrySet()) {
                evaluateResultB.append(entry.getKey()).append("  ").append((Object)entry.getValue()).append("\n");
            }
        }
        return this.listAssertOk;
    }

    public ReturnType evaluateXpath(String xpathline, String text) {
        XPathExpression expr;
        ReturnType returnType = ReturnType.SYNTAX_OK;
        String exprXpath = xpathline;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(text)));
        }
        catch (Exception e) {
            returnType = ReturnType.SYNTAX_NOK;
            return returnType;
        }
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try {
            expr = xpath.compile(exprXpath);
        }
        catch (XPathExpressionException e) {
            returnType = ReturnType.SYNTAX_NOK;
            return returnType;
        }
        try {
            NodeList result = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            returnType = result.getLength() > 0 ? ReturnType.FOUND : ReturnType.NOT_FOUND;
        }
        catch (XPathExpressionException e) {
            returnType = ReturnType.NOT_FOUND;
            e.printStackTrace();
        }
        return returnType;
    }

    public List<String> getListAssertOk(String str) {
        ArrayList<String> list = new ArrayList<String>();
        boolean addNextLine = false;
        if (str != null) {
            String[] strList;
            for (String line : strList = str.split("(\\n|;)")) {
                if (line == null || line.length() <= 0) continue;
                if (line.contains(syntaxAsOk)) {
                    addNextLine = true;
                    continue;
                }
                if (line.contains(syntaxAsNok)) {
                    addNextLine = false;
                    continue;
                }
                if (!addNextLine) continue;
                list.add(line);
            }
        }
        return list;
    }

    public List<String> getListAssertNok(String str) {
        ArrayList<String> list = new ArrayList<String>();
        boolean addNextLine = false;
        if (str != null) {
            String[] strList;
            for (String line : strList = str.split("(\\n|;)")) {
                if (line == null || line.length() <= 0) continue;
                if (line.contains(syntaxAsNok)) {
                    addNextLine = true;
                    continue;
                }
                if (line.contains(syntaxAsOk)) {
                    addNextLine = false;
                    continue;
                }
                if (!addNextLine) continue;
                list.add(line);
            }
        }
        return list;
    }

    public Document generateXmlFile(String jobName, String path) throws JenkinsPluginException {
        Document doc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("testsuites");
            Attr nameAttr = doc.createAttribute("name");
            nameAttr.setValue(jobName);
            rootElement.setAttributeNode(nameAttr);
            Attr idAttr = doc.createAttribute("id");
            idAttr.setValue("");
            rootElement.setAttributeNode(idAttr);
            doc.appendChild(rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            String filename = jobName + "_TestCaseReport.xml";
            StreamResult result = new StreamResult(new File(path + filename));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new JenkinsPluginException("error during creation of xml file for TestCase report \n" + e.getMessage() + "\n");
        }
        catch (TransformerException tfe) {
            throw new JenkinsPluginException("error during creation of xml file for TestCase report \n" + tfe.getMessage() + "\n");
        }
        return doc;
    }

    public void addAssertNokIntoXmlFile(Document doc, String path, TestCase testcase, List<String> displaylist) throws JenkinsPluginException, TransformerException {
        if (doc != null) {
            String projectname = testcase.getProjectname();
            Boolean projetFound = false;
            NodeList nodelists = doc.getElementsByTagName("testsuite");
            for (int i = 0; i < nodelists.getLength(); ++i) {
                Element testsuite = (Element)nodelists.item(i);
                String testcaseName = testsuite.getAttribute("name");
                if (testcaseName == null || !testcaseName.equals(testcase.getProjectname())) continue;
                projetFound = true;
                Element newTestcase = doc.createElement("testcase");
                if (testcase.getType() != null && testcase.getType().equals("connector")) {
                    newTestcase.setAttribute("name", "T:" + testcase.getTransaction() + ":" + testcase.getTypeName() + ":" + testcase.getName());
                } else {
                    newTestcase.setAttribute("name", "S:" + testcase.getTypeName() + ":" + testcase.getName());
                }
                Element newFailure = doc.createElement("failure");
                newFailure.setAttribute("message", "error");
                newFailure.setAttribute("message", "error");
                newFailure.setTextContent(displaylist.toString());
                newTestcase.appendChild(newFailure);
                testsuite.appendChild(newTestcase);
            }
            if (!projetFound.booleanValue()) {
                Element newTestsuite = doc.createElement("testsuite");
                newTestsuite.setAttribute("id", "");
                newTestsuite.setAttribute("name", testcase.getProjectname());
                Element newTestcase = doc.createElement("testcase");
                if (testcase.getType() != null && testcase.getType().equals("connector")) {
                    newTestcase.setAttribute("name", "T:" + testcase.getTransaction() + ":" + testcase.getTypeName() + ":" + testcase.getName());
                } else {
                    newTestcase.setAttribute("name", "S:" + testcase.getTypeName() + ":" + testcase.getName());
                }
                Element newFailure = doc.createElement("failure");
                newFailure.setAttribute("message", "error");
                newFailure.setAttribute("message", "error");
                newFailure.setTextContent(displaylist.toString());
                newTestcase.appendChild(newFailure);
                newTestsuite.appendChild(newTestcase);
                Element testsuites = doc.getDocumentElement();
                if (testsuites == null) {
                    throw new JenkinsPluginException("error of junit xml document ");
                }
                testsuites.appendChild(newTestsuite);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(path);
            transformer.transform(source, result);
        }
    }

    public void addAssertOkIntoXmlFile(Document doc, String path, TestCase testcase) throws JenkinsPluginException, TransformerException {
        if (doc != null) {
            String projectname = testcase.getProjectname();
            Boolean projetFound = false;
            NodeList nodelists = doc.getElementsByTagName("testsuite");
            for (int i = 0; i < nodelists.getLength(); ++i) {
                Element testsuite = (Element)nodelists.item(i);
                String testcaseName = testsuite.getAttribute("name");
                if (testcaseName == null || !testcaseName.equals(testcase.getProjectname())) continue;
                projetFound = true;
                Element newTestcase = doc.createElement("testcase");
                if (testcase.getType() != null && testcase.getType().equals("connector")) {
                    newTestcase.setAttribute("name", "T:" + testcase.getTransaction() + ":" + testcase.getTypeName() + ":" + testcase.getName());
                } else {
                    newTestcase.setAttribute("name", "S:" + testcase.getTypeName() + ":" + testcase.getName());
                }
                testsuite.appendChild(newTestcase);
            }
            if (!projetFound.booleanValue()) {
                Element newTestsuite = doc.createElement("testsuite");
                newTestsuite.setAttribute("id", "");
                newTestsuite.setAttribute("name", testcase.getProjectname());
                Element newTestcase = doc.createElement("testcase");
                if (testcase.getType() != null && testcase.getType().equals("connector")) {
                    newTestcase.setAttribute("name", "T:" + testcase.getTransaction() + ":" + testcase.getTypeName() + ":" + testcase.getName());
                } else {
                    newTestcase.setAttribute("name", "S:" + testcase.getTypeName() + ":" + testcase.getName());
                }
                newTestsuite.appendChild(newTestcase);
                Element testsuites = doc.getDocumentElement();
                if (testsuites == null) {
                    throw new JenkinsPluginException("error of junit xml document ");
                }
                testsuites.appendChild(newTestsuite);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(path);
            transformer.transform(source, result);
        }
    }

    public static enum AssertType {
        OK,
        NOK;

    }

    public static enum ReturnType {
        SYNTAX_OK("Xpath syntax is correct", 1),
        SYNTAX_NOK("Xpath syntax is not correct", 2),
        FOUND("Xpath syntax is correct and found", 0),
        NOT_FOUND("Xpath syntax is correct but not found ", 3);

        String message;
        int codeError;

        private ReturnType(String msg, int code) {
            this.message = msg;
            this.codeError = code;
        }

        String getMessage() {
            return this.message;
        }
    }
}

