/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractCondition
implements Condition {
    private final ReentrantLock queueLock = new ReentrantLock();
    private final java.util.concurrent.locks.Condition condition = this.queueLock.newCondition();

    AbstractCondition() {
    }

    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        this.queueLock.lock();
        try {
            this.condition.awaitNanos(timeout);
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.queueLock.lock();
        try {
            this.condition.await();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void signal() {
        this.queueLock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

