/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.PaddedAtomicLong;
import com.conversantmedia.util.concurrent.PaddedLong;
import java.util.concurrent.atomic.AtomicLong;

public class PushPullConcurrentQueue<E>
implements ConcurrentQueue<E> {
    protected final int size;
    protected final long mask;
    protected final E[] buffer;
    protected final AtomicLong tail = new PaddedAtomicLong(0L);
    protected final AtomicLong head = new PaddedAtomicLong(0L);
    protected final PaddedLong tailCache = new PaddedLong();
    protected final PaddedLong headCache = new PaddedLong();

    public PushPullConcurrentQueue(int size) {
        int rs;
        for (rs = 1; rs < size; rs <<= 1) {
        }
        this.size = rs;
        this.mask = rs - 1;
        this.buffer = new Object[this.size];
    }

    @Override
    public boolean offer(E e) {
        if (e != null) {
            long tail = this.tail.get();
            long queueStart = tail - (long)this.size;
            if (this.headCache.value > queueStart || (this.headCache.value = this.head.get()) > queueStart) {
                int dx = (int)(tail & this.mask);
                this.buffer[dx] = e;
                this.tail.lazySet(tail + 1L);
                return true;
            }
            return false;
        }
        throw new NullPointerException("Invalid element");
    }

    @Override
    public E poll() {
        long head = this.head.get();
        if (head < this.tailCache.value || head < (this.tailCache.value = this.tail.get())) {
            int dx = (int)(head & this.mask);
            E e = this.buffer[dx];
            this.buffer[dx] = null;
            this.head.lazySet(head + 1L);
            return e;
        }
        return null;
    }

    @Override
    public int remove(E[] e) {
        int n = 0;
        this.headCache.value = this.head.get();
        int nMax = e.length;
        long end = this.tail.get();
        for (long i = this.headCache.value; n < nMax && i < end; ++i) {
            int dx = (int)(i & this.mask);
            e[n++] = this.buffer[dx];
            this.buffer[dx] = null;
        }
        this.head.lazySet(this.headCache.value + (long)n);
        return n;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.head.lazySet(this.tail.get());
    }

    @Override
    public final E peek() {
        return this.buffer[(int)(this.head.get() & this.mask)];
    }

    @Override
    public final int size() {
        return (int)(this.tail.get() - this.head.get());
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.tail.get() == this.head.get();
    }

    @Override
    public final boolean contains(Object o) {
        if (o != null) {
            long end = this.tail.get();
            for (long i = this.head.get(); i < end; ++i) {
                E e = this.buffer[(int)(i & this.mask)];
                if (!o.equals(e)) continue;
                return true;
            }
        }
        return false;
    }
}

