/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.PaddedAtomicLong;
import com.conversantmedia.util.concurrent.PaddedLong;
import java.util.concurrent.atomic.AtomicLong;

public class MultithreadConcurrentQueue<E>
implements ConcurrentQueue<E> {
    protected final int size;
    protected final long mask;
    protected final E[] buffer;
    protected final AtomicLong tail = new PaddedAtomicLong(0L);
    protected final AtomicLong head = new PaddedAtomicLong(0L);
    protected final PaddedLong tailCache = new PaddedLong(0L);
    protected final PaddedLong headCache = new PaddedLong(0L);
    protected final AtomicLong tailCursor = new PaddedAtomicLong(0L);
    protected final AtomicLong headCursor = new PaddedAtomicLong(0L);

    public MultithreadConcurrentQueue(int capacity) {
        int c;
        for (c = 1; c < capacity; c <<= 1) {
        }
        this.size = c;
        this.mask = (long)this.size - 1L;
        this.buffer = new Object[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        while (true) {
            long tailSeq;
            long queueStart;
            if (this.headCache.value > (queueStart = (tailSeq = this.tail.get()) - (long)this.size) || (this.headCache.value = this.head.get()) > queueStart) {
                long tailNext = tailSeq + 1L;
                if (this.tailCursor.compareAndSet(tailSeq, tailNext)) {
                    try {
                        int tailSlot = (int)(tailSeq & this.mask);
                        this.buffer[tailSlot] = e;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.tail.lazySet(tailNext);
                    }
                }
            } else {
                return false;
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        while (true) {
            long head;
            if (this.tailCache.value > (head = this.head.get()) || (this.tailCache.value = this.tail.get()) > head) {
                long headNext = head + 1L;
                if (this.headCursor.compareAndSet(head, headNext)) {
                    try {
                        int pollSlot = (int)(head & this.mask);
                        E pollObj = this.buffer[pollSlot];
                        this.buffer[pollSlot] = null;
                        E e = pollObj;
                        return e;
                    }
                    finally {
                        this.head.lazySet(headNext);
                    }
                }
            } else {
                return null;
            }
            Thread.yield();
        }
    }

    @Override
    public final E peek() {
        return this.buffer[(int)(this.head.get() & this.mask)];
    }

    @Override
    public int remove(E[] e) {
        block2: {
            int nToRead;
            long pollPos;
            int maxElements = e.length;
            do {
                pollPos = this.head.get();
                nToRead = Math.min((int)(this.tail.get() - pollPos), maxElements);
                if (nToRead <= 0) break block2;
                for (int i = 0; i < nToRead; ++i) {
                    int pollSlot = (int)(pollPos + (long)i & this.mask);
                    e[i] = this.buffer[pollSlot];
                }
            } while (!this.headCursor.compareAndSet(pollPos, pollPos + (long)nToRead));
            this.head.lazySet(pollPos + (long)nToRead);
            return nToRead;
        }
        return 0;
    }

    @Override
    public final int size() {
        return (int)(this.tail.get() - this.head.get());
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        long tail;
        long head;
        while (!this.headCursor.compareAndSet(head = this.head.get(), head + 1L)) {
        }
        while (!this.tailCursor.compareAndSet(tail = this.tail.get(), tail + 1L)) {
        }
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.head.lazySet(tail + 1L);
        this.tail.lazySet(tail + 1L);
        this.headCursor.lazySet(tail + 1L);
    }

    @Override
    public final boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[slot] == null || !this.buffer[slot].equals(o)) continue;
            return true;
        }
        return false;
    }
}

