/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.listener.OnDismissListener;
import com.bigkoo.pickerview.utils.PickerViewAnimateUtil;

public class BasePickerView {
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private Context context;
    protected ViewGroup contentContainer;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private ViewGroup dialogView;
    protected int pickerview_timebtn_nor = -16417281;
    protected int pickerview_timebtn_pre = -4007179;
    protected int pickerview_bg_topbar = -657931;
    protected int pickerview_topbar_title = -16777216;
    protected int bgColor_default = -1;
    private OnDismissListener onDismissListener;
    private boolean dismissing;
    private Animation outAnim;
    private Animation inAnim;
    private boolean isShowing;
    private int gravity = 80;
    private Dialog mDialog;
    private boolean cancelable;
    protected View clickView;
    private View.OnKeyListener onKeyBackListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 0 && BasePickerView.this.isShowing()) {
                BasePickerView.this.dismiss();
                return true;
            }
            return false;
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                BasePickerView.this.dismiss();
            }
            return false;
        }
    };

    public BasePickerView(Context context) {
        this.context = context;
    }

    protected void initViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        if (this.isDialog()) {
            this.dialogView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, null, false);
            this.dialogView.setBackgroundColor(0);
            this.contentContainer = (ViewGroup)this.dialogView.findViewById(R.id.content_container);
            this.params.leftMargin = 30;
            this.params.rightMargin = 30;
            this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.createDialog();
            this.dialogView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BasePickerView.this.dismiss();
                }
            });
        } else {
            this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
            this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, this.decorView, false);
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
            this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
        }
        this.setKeyBackCancelable(true);
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        this.contentContainer.startAnimation(this.inAnim);
    }

    public void show() {
        if (this.isDialog()) {
            this.showDialog();
        } else {
            if (this.isShowing()) {
                return;
            }
            this.isShowing = true;
            this.onAttached((View)this.rootView);
            this.rootView.requestFocus();
        }
    }

    public void show(View v) {
        this.clickView = v;
        this.show();
    }

    public boolean isShowing() {
        if (this.isDialog()) {
            return false;
        }
        return this.rootView.getParent() != null || this.isShowing;
    }

    public void dismiss() {
        if (this.isDialog()) {
            this.dismissDialog();
        } else {
            if (this.dismissing) {
                return;
            }
            this.dismissing = true;
            this.outAnim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    BasePickerView.this.decorView.post(new Runnable(){

                        @Override
                        public void run() {
                            BasePickerView.this.dismissImmediately();
                        }
                    });
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.contentContainer.startAnimation(this.outAnim);
        }
    }

    public void dismissImmediately() {
        this.decorView.removeView((View)this.rootView);
        this.isShowing = false;
        this.dismissing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public Animation getInAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public BasePickerView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public BasePickerView setKeyBackCancelable(boolean isCancelable) {
        ViewGroup View2 = this.isDialog() ? this.dialogView : this.rootView;
        View2.setFocusable(isCancelable);
        View2.setFocusableInTouchMode(isCancelable);
        if (isCancelable) {
            View2.setOnKeyListener(this.onKeyBackListener);
        } else {
            View2.setOnKeyListener(null);
        }
        return this;
    }

    protected BasePickerView setOutSideCancelable(boolean isCancelable) {
        if (this.rootView != null) {
            View view = this.rootView.findViewById(R.id.outmost_container);
            if (isCancelable) {
                view.setOnTouchListener(this.onCancelableTouchListener);
            } else {
                view.setOnTouchListener(null);
            }
        }
        return this;
    }

    public void setDialogOutSideCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public View findViewById(int id2) {
        return this.contentContainer.findViewById(id2);
    }

    public void createDialog() {
        if (this.dialogView != null) {
            this.mDialog = new Dialog(this.context, R.style.custom_dialog2);
            this.mDialog.setCancelable(this.cancelable);
            this.mDialog.setContentView((View)this.dialogView);
            this.mDialog.getWindow().setWindowAnimations(R.style.pickerview_dialogAnim);
            this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (BasePickerView.this.onDismissListener != null) {
                        BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                    }
                }
            });
        }
    }

    public void showDialog() {
        if (this.mDialog != null) {
            this.mDialog.show();
        }
    }

    public void dismissDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public boolean isDialog() {
        return false;
    }
}

