/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.WheelTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class TimePickerView
extends BasePickerView
implements View.OnClickListener {
    WheelTime wheelTime;
    private Button btnSubmit;
    private Button btnCancel;
    private TextView tvTitle;
    private OnTimeSelectListener timeSelectListener;
    private int gravity = 17;
    private Type type;
    private String Str_Submit;
    private String Str_Cancel;
    private String Str_Title;
    private int Color_Submit;
    private int Color_Cancel;
    private int Color_Title;
    private int Color_Background_Wheel;
    private int Color_Background_Title;
    private int Size_Submit_Cancel;
    private int Size_Title;
    private int Size_Content;
    private Date date;
    private int startYear;
    private int endYear;
    private boolean cyclic;
    private boolean cancelable;
    private String label_year;
    private String label_month;
    private String label_day;
    private String label_hours;
    private String label_mins;
    private String label_seconds;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";

    public TimePickerView(Builder builder) {
        super(builder.context);
        this.timeSelectListener = builder.timeSelectListener;
        this.gravity = builder.gravity;
        this.type = builder.type;
        this.Str_Submit = builder.Str_Submit;
        this.Str_Cancel = builder.Str_Cancel;
        this.Str_Title = builder.Str_Title;
        this.Color_Submit = builder.Color_Submit;
        this.Color_Cancel = builder.Color_Cancel;
        this.Color_Title = builder.Color_Title;
        this.Color_Background_Wheel = builder.Color_Background_Wheel;
        this.Color_Background_Title = builder.Color_Background_Title;
        this.Size_Submit_Cancel = builder.Size_Submit_Cancel;
        this.Size_Title = builder.Size_Title;
        this.Size_Content = builder.Size_Content;
        this.startYear = builder.startYear;
        this.endYear = builder.endYear;
        this.date = builder.date;
        this.cyclic = builder.cyclic;
        this.cancelable = builder.cancelable;
        this.label_year = builder.label_year;
        this.label_month = builder.label_month;
        this.label_day = builder.label_day;
        this.label_hours = builder.label_hours;
        this.label_mins = builder.label_mins;
        this.label_seconds = builder.label_seconds;
        this.initView(builder.context);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.pickerview_time, this.contentContainer);
        this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        this.btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
        this.btnCancel = (Button)this.findViewById(R.id.btnCancel);
        this.btnSubmit.setTag((Object)TAG_SUBMIT);
        this.btnCancel.setTag((Object)TAG_CANCEL);
        this.btnSubmit.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.btnSubmit.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Submit) ? context.getResources().getString(R.string.pickerview_submit) : this.Str_Submit));
        this.btnCancel.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Cancel) ? context.getResources().getString(R.string.pickerview_cancel) : this.Str_Cancel));
        this.tvTitle.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.Str_Title) ? "" : this.Str_Title));
        this.btnSubmit.setTextColor(this.Color_Submit == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_timebtn_nor) : this.Color_Submit);
        this.btnCancel.setTextColor(this.Color_Cancel == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_timebtn_nor) : this.Color_Cancel);
        this.tvTitle.setTextColor(this.Color_Title == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_topbar_title) : this.Color_Title);
        this.btnSubmit.setTextSize((float)this.Size_Submit_Cancel);
        this.btnCancel.setTextSize((float)this.Size_Submit_Cancel);
        this.tvTitle.setTextSize((float)this.Size_Title);
        LinearLayout timePickerView = (LinearLayout)this.findViewById(R.id.timepicker);
        RelativeLayout rv_top_bar = (RelativeLayout)this.findViewById(R.id.rv_topbar);
        rv_top_bar.setBackgroundColor(this.Color_Background_Title == 0 ? ContextCompat.getColor((Context)context, (int)R.color.pickerview_bg_topbar) : this.Color_Background_Title);
        timePickerView.setBackgroundColor(this.Color_Background_Wheel == 0 ? ContextCompat.getColor((Context)context, (int)R.color.bgColor_default) : this.Color_Background_Wheel);
        this.wheelTime = new WheelTime((View)timePickerView, this.type, this.gravity, this.Size_Content);
        if (this.startYear != 0 && this.endYear != 0 && this.startYear <= this.endYear) {
            this.setRange();
        }
        this.setTime();
        this.wheelTime.setLabels(this.label_year, this.label_month, this.label_day, this.label_hours, this.label_mins, this.label_seconds);
        this.setOutSideCancelable(this.cancelable);
        this.wheelTime.setCyclic(this.cyclic);
    }

    private void setRange() {
        this.wheelTime.setStartYear(this.startYear);
        this.wheelTime.setEndYear(this.endYear);
    }

    private void setTime() {
        Calendar calendar = Calendar.getInstance();
        if (this.date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            calendar.setTime(this.date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hours = calendar.get(11);
        int minute = calendar.get(12);
        int seconds = calendar.get(13);
        this.wheelTime.setPicker(year, month, day, hours, minute, seconds);
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_CANCEL)) {
            this.dismiss();
        } else {
            if (this.timeSelectListener != null) {
                try {
                    Date date = WheelTime.dateFormat.parse(this.wheelTime.getTime());
                    this.timeSelectListener.onTimeSelect(date, v);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.dismiss();
        }
    }

    public static interface OnTimeSelectListener {
        public void onTimeSelect(Date var1, View var2);
    }

    public static class Builder {
        private Context context;
        private OnTimeSelectListener timeSelectListener;
        private Type type = Type.ALL;
        private int gravity = 17;
        private String Str_Submit;
        private String Str_Cancel;
        private String Str_Title;
        private int Color_Submit;
        private int Color_Cancel;
        private int Color_Title;
        private int Color_Background_Wheel;
        private int Color_Background_Title;
        private int Size_Submit_Cancel = 17;
        private int Size_Title = 18;
        private int Size_Content = 18;
        private Date date;
        private int startYear;
        private int endYear;
        private boolean cyclic = false;
        private boolean cancelable = true;
        private String label_year;
        private String label_month;
        private String label_day;
        private String label_hours;
        private String label_mins;
        private String label_seconds;

        public Builder(Context context, OnTimeSelectListener listener) {
            this.context = context;
            this.timeSelectListener = listener;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setSubmitText(String Str_Cancel) {
            this.Str_Submit = Str_Cancel;
            return this;
        }

        public Builder setCancelText(String Str_Cancel) {
            this.Str_Cancel = Str_Cancel;
            return this;
        }

        public Builder setTitleText(String Str_Title) {
            this.Str_Title = Str_Title;
            return this;
        }

        public Builder setSubmitColor(int Color_Submit) {
            this.Color_Submit = Color_Submit;
            return this;
        }

        public Builder setCancelColor(int Color_Cancel) {
            this.Color_Cancel = Color_Cancel;
            return this;
        }

        public Builder setBgColor(int Color_Background_Wheel) {
            this.Color_Background_Wheel = Color_Background_Wheel;
            return this;
        }

        public Builder setTitleBgColor(int Color_Background_Title) {
            this.Color_Background_Title = Color_Background_Title;
            return this;
        }

        public Builder setTitleColor(int Color_Title) {
            this.Color_Title = Color_Title;
            return this;
        }

        public Builder setSubCalSize(int Size_Submit_Cancel) {
            this.Size_Submit_Cancel = Size_Submit_Cancel;
            return this;
        }

        public Builder setTitleSize(int Size_Title) {
            this.Size_Title = Size_Title;
            return this;
        }

        public Builder setContentSize(int Size_Content) {
            this.Size_Content = Size_Content;
            return this;
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setRange(int startYear, int endYear) {
            this.startYear = startYear;
            this.endYear = endYear;
            return this;
        }

        public Builder isCyclic(boolean cyclic) {
            this.cyclic = cyclic;
            return this;
        }

        public Builder setOutSideCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setLabel(String label_year, String label_month, String label_day, String label_hours, String label_mins, String label_seconds) {
            this.label_year = label_year;
            this.label_month = label_month;
            this.label_day = label_day;
            this.label_hours = label_hours;
            this.label_mins = label_mins;
            this.label_seconds = label_seconds;
            return this;
        }

        public TimePickerView build() {
            return new TimePickerView(this);
        }
    }

    public static enum Type {
        ALL,
        YEAR_MONTH_DAY,
        HOURS_MINS,
        MONTH_DAY_HOUR_MIN,
        YEAR_MONTH;

    }
}

