/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.dsl.builder.TestActionBuilder;
import com.consol.citrus.dsl.builder.TestActionContainerBuilder;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.ApplyTestBehaviorAction;
import com.consol.citrus.dsl.runner.TestRunner;
import java.util.List;

public abstract class AbstractTestContainerBuilder<T extends TestActionContainer>
extends AbstractTestActionBuilder<T>
implements TestActionContainerBuilder<T> {
    protected TestRunner runner;
    protected TestDesigner designer;
    protected final T container;

    public AbstractTestContainerBuilder(TestRunner runner, T container) {
        super(container);
        this.runner = runner;
        this.container = container;
    }

    public AbstractTestContainerBuilder(TestDesigner designer, T container) {
        super(container);
        this.designer = designer;
        this.container = container;
    }

    public T actions(TestAction ... actions) {
        for (int i = 0; i < actions.length; ++i) {
            TestAction currentAction = this.getAction(actions[i]);
            if (currentAction instanceof ApplyTestBehaviorAction || currentAction instanceof com.consol.citrus.dsl.design.ApplyTestBehaviorAction) continue;
            if (this.container.getActions().size() == i) {
                this.container.addTestAction(currentAction);
                continue;
            }
            if (this.container.getActions().get(i) instanceof DelegatingTestAction) {
                if (currentAction instanceof DelegatingTestAction && !((DelegatingTestAction)currentAction).getDelegate().equals(((DelegatingTestAction)((Object)this.container.getActions().get(i))).getDelegate())) {
                    this.container.getActions().add(i, ((DelegatingTestAction)currentAction).getDelegate());
                    continue;
                }
                if (currentAction instanceof DelegatingTestAction || currentAction.equals(((DelegatingTestAction)((Object)this.container.getActions().get(i))).getDelegate())) continue;
                this.container.getActions().add(i, currentAction);
                continue;
            }
            if (((TestAction)this.container.getActions().get(i)).equals(currentAction)) continue;
            this.container.getActions().add(i, currentAction);
        }
        if (this.runner != null) {
            return (T)((TestActionContainer)this.runner.run(this.container));
        }
        this.designer.action((TestAction)this.container);
        return this.container;
    }

    private TestAction getAction(TestAction action) {
        if (action instanceof TestActionBuilder) {
            return ((TestActionBuilder)action).build();
        }
        return action;
    }

    @Override
    public List<TestAction> getActions() {
        return ((TestActionContainer)super.build()).getActions();
    }
}

