/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag.operators;

import android.support.annotation.Nullable;
import com.comuto.flag.model.Flag;
import com.comuto.flag.operators.Operator;
import org.apache.commons.lang3.StringUtils;

public class PercentageOperator
extends Operator<String> {
    private static final int MAX_PERCENTAGE = 100;
    private final int percentage;
    private final int shift;

    public PercentageOperator(String name, int percentage, int shift) {
        super(name);
        this.percentage = percentage;
        this.shift = shift;
    }

    @Override
    public Flag.FlagResultStatus appliesTo(@Nullable String value) throws NumberFormatException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Flag.FlagResultStatus.DISABLED;
        }
        int val = Integer.parseInt(value);
        int asPercentage = val % 100;
        return asPercentage >= this.shift && asPercentage < this.percentage + this.shift ? Flag.FlagResultStatus.ENABLED : Flag.FlagResultStatus.DISABLED;
    }
}

