/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag.operators;

import android.support.annotation.Nullable;
import android.util.Log;
import com.comuto.flag.model.Flag;
import com.comuto.flag.operators.Operator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppVersionOperator
extends Operator<String> {
    public static final String TAG = "AppVersionOperator";
    final List<String> appVersion;

    public AppVersionOperator(String name, List<String> appVersion) {
        super(name);
        this.appVersion = appVersion;
    }

    @Override
    public Flag.FlagResultStatus appliesTo(@Nullable String value) {
        if (null != value) {
            String[] valuesArray = this.populateValues(value);
            String[] versionsArray = new String[3];
            String operator = "";
            Iterator<String> iterator = this.appVersion.iterator();
            if (iterator.hasNext()) {
                String version = iterator.next();
                if (version.contains("<")) {
                    operator = "<";
                } else if (version.contains("<=")) {
                    operator = "<=";
                }
                Pattern p = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?");
                Matcher matcher = p.matcher(version);
                if (matcher.matches()) {
                    Log.e((String)"AppVersionOperator <=?*", (String)("value = " + value));
                    for (int i = 1; i < matcher.groupCount(); ++i) {
                        versionsArray[i - 1] = matcher.group(i);
                    }
                } else if (value.contains(">") || value.contains(">=")) {
                    Log.e((String)TAG, (String)("value = " + value));
                } else if (value.contains("=") || value.contains("==")) {
                    Log.e((String)TAG, (String)("value = " + value));
                } else {
                    Log.e((String)TAG, (String)("value = " + value));
                }
                return this.checkVersionOperator(valuesArray, versionsArray, operator);
            }
        }
        return Flag.FlagResultStatus.UNKNOWN;
    }

    private Flag.FlagResultStatus checkVersionOperator(String[] valuesArray, String[] versionsArray, String operator) {
        if (valuesArray.length != versionsArray.length) {
            return Flag.FlagResultStatus.DISABLED;
        }
        for (int pos = 0; pos < valuesArray.length; ++pos) {
            if (operator.equals("<") || !operator.equals("=") || this.equals(valuesArray[pos], versionsArray[pos])) continue;
            return Flag.FlagResultStatus.DISABLED;
        }
        return Flag.FlagResultStatus.ENABLED;
    }

    private boolean inf(String value, String version) {
        try {
            int val = Integer.parseInt(value);
            int ver = Integer.parseInt(version);
            return val > ver;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private boolean equals(String value, String version) {
        return value.equals(version);
    }

    private String[] populateValues(String value) {
        String[] valuesArray = value.split("\\.");
        for (int i = 0; i < valuesArray.length; ++i) {
            Log.e((String)TAG, (String)("valuesArray = " + valuesArray[i]));
        }
        return valuesArray;
    }
}

