package com.comuto.flag.operators;

import android.support.annotation.Nullable;
import android.util.Log;
import com.comuto.flag.model.Flag;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppVersionOperator extends Operator<String> {

    public static final String TAG = "AppVersionOperator";
    final List<String> appVersion;

    public AppVersionOperator(String name, List<String> appVersion) {
        super(name);
        this.appVersion = appVersion;
    }

    @Override
    public Flag.FlagResultStatus appliesTo(@Nullable String value) {
        if (null != value) {
            String[] valuesArray = populateValues(value);
            String[] versionsArray = new String[3];
            String operator = "";
            for (String version : appVersion) {
                if (version.contains("<")) {
                    operator = "<";
                } else if (version.contains("<=")) {
                    operator = "<=";
                }

                Pattern p = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?");
                Matcher matcher = p.matcher(version);
                if (matcher.matches()) {
                    Log.e("AppVersionOperator <=?*", "value = " + value);
                    for (int i = 1; i < matcher.groupCount(); ++i) {
                        versionsArray[i - 1] = matcher.group(i);
                        //                        Log.e(TAG, "elem = " + elem);
                    }
                } else if (value.contains(">") || value.contains(">=")) {
                    Log.e(TAG, "value = " + value);
                } else if (value.contains("=") || value.contains("==")) {
                    Log.e("AppVersionOperator", "value = " + value);
                } else {
                    Log.e("AppVersionOperator", "value = " + value);
                }
                return checkVersionOperator(valuesArray, versionsArray, operator);
            }
        }
        return Flag.FlagResultStatus.UNKNOWN;
    }

    private Flag.FlagResultStatus checkVersionOperator(String[] valuesArray, String[] versionsArray, String operator) {
        if (valuesArray.length != versionsArray.length) return Flag.FlagResultStatus.DISABLED;
        for (int pos = 0; pos < valuesArray.length; ++pos) {
            if (operator.equals("<")) {
//                inf(valuesArray[pos], versionsArray[pos]);
            } else if (operator.equals("=")) {
                if (!equals(valuesArray[pos], versionsArray[pos])) return Flag.FlagResultStatus.DISABLED;
            }
        }
        return Flag.FlagResultStatus.ENABLED;
    }

    private boolean inf(String value, String version) {
        try {
            int val = Integer.parseInt(value);
            int ver = Integer.parseInt(version);
            return val > ver;
        } catch(NumberFormatException e) {
            return false;
        } catch(NullPointerException e) {
            return false;
        }
    }

    private boolean equals(String value, String version) {
        return value.equals(version);
    }

    private String[] populateValues(final String value) {
        String[] valuesArray = value.split("\\.");
        for (int i = 0; i < valuesArray.length; ++i) {
            Log.e("AppVersionOperator", "valuesArray = " + valuesArray[i]);
        }
        return valuesArray;
    }
}
