/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag.operators;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.comuto.flag.operators.Operator;

public class PercentageOperator
extends Operator<String> {
    private static final int MAX_PERCENTAGE = 100;
    private final int percentage;
    private final int shift;

    public PercentageOperator(String name, int percentage, int shift) {
        super(name);
        this.percentage = percentage;
        this.shift = shift;
    }

    @Override
    public boolean appliesTo(@Nullable String value) throws NumberFormatException {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        int val = Integer.parseInt(value);
        int asPercentage = val % 100;
        return asPercentage >= this.shift && asPercentage < this.percentage + this.shift;
    }
}

