/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag;

import com.comuto.flag.model.Flag;
import com.comuto.flag.model.FlagContextInterface;
import com.comuto.flag.strategy.AffirmativeStrategy;
import com.comuto.flag.strategy.MajorityStrategy;
import com.comuto.flag.strategy.Strategy;
import com.comuto.flag.strategy.UnanimousStrategy;

public class FlaggrManager {
    private static Strategy strategy;

    public static boolean isActivated(Flag flag, FlagContextInterface context, boolean defaultValue) {
        switch (flag.getStatus()) {
            case "always-active": {
                return true;
            }
            case "inactive": {
                return false;
            }
            case "conditionally-active": {
                return FlaggrManager.checkConditions(flag, context);
            }
        }
        return defaultValue;
    }

    public static boolean isActivated(Flag flag, FlagContextInterface context) {
        return FlaggrManager.isActivated(flag, context, false);
    }

    private static boolean checkConditions(Flag flag, FlagContextInterface context) {
        switch (flag.getStrategy()) {
            case "unanimous": {
                strategy = new UnanimousStrategy();
                break;
            }
            case "majority": {
                strategy = new MajorityStrategy();
                break;
            }
            case "affirmative": {
                strategy = new AffirmativeStrategy();
            }
        }
        return strategy.isFlagActivated(flag, context);
    }
}

