/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.StringRes;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import com.comuto.flag.FlaggrComponent;
import com.comuto.flag.FlaggrManager;
import com.comuto.flag.FlagsCallback;
import com.comuto.flag.FlagsLoader;
import com.comuto.flag.model.Flag;
import com.comuto.flag.model.FlagContextInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class Flaggr {
    private static final String TAG = "Flaggr";
    protected static final String FLAGGR_SHARED_PREFERENCES_PREFIX = "FLAGGR_ID_";
    private static final String FLAGS_PREF_KEY = "FLAGS_KEYS";
    @VisibleForTesting
    static volatile Flaggr singleton;
    @Inject
    FlagsLoader flagsLoader;
    @Inject
    SharedPreferences preferences;
    private List<Flag> flags;
    private final Map<String, Boolean> flagCaches = new HashMap<String, Boolean>();
    private String configUrl;
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Flaggr with(Context context) {
        if (null != singleton) return singleton;
        Class<Flaggr> clazz = Flaggr.class;
        synchronized (Flaggr.class) {
            singleton = new Flaggr(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private Flaggr(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.context = context.getApplicationContext();
        FlaggrComponent flaggrComponent = FlaggrComponent.Initializer.init(this.context);
        flaggrComponent.inject(this);
    }

    public void loadConfig(String configUrl) {
        this.configUrl = configUrl;
        this.downloadConfig(configUrl);
    }

    public void reloadConfig() {
        this.downloadConfig(this.configUrl);
    }

    private void downloadConfig(String configUrl) {
        this.flagCaches.clear();
        try {
            this.flagsLoader.load(configUrl, new FlagsCallback(){

                @Override
                public void onLoadFlags(String jsonResponse, List<Flag> results) {
                    Flaggr.this.flags = results;
                    Flaggr.this.preferences.edit().putString(Flaggr.FLAGS_PREF_KEY, jsonResponse).apply();
                }
            });
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception when loading config", (Throwable)ex);
        }
    }

    public boolean isActive(@StringRes int resId, FlagContextInterface flagContext) {
        return this.isActive(this.context.getString(resId), flagContext);
    }

    public boolean isActive(String flagName, FlagContextInterface flagContext) {
        return this.isActive(flagName, flagContext, false);
    }

    public boolean isActive(String flagName, FlagContextInterface flagContext, boolean defaultValue) {
        if (TextUtils.isEmpty((CharSequence)flagName)) {
            return defaultValue;
        }
        if (this.flagCaches.containsKey(flagName)) {
            return this.flagCaches.get(flagName);
        }
        if (null != this.flags && null != flagContext) {
            for (Flag flag : this.flags) {
                if (null == flag || null == flag.getName() || !flag.getName().equals(flagName)) continue;
                boolean isActivated = FlaggrManager.isActivated(flag, flagContext, defaultValue);
                this.flagCaches.put(flagName, isActivated);
                return isActivated;
            }
        }
        Log.w((String)TAG, (String)("The flag " + flagName + " is not found."));
        return defaultValue;
    }

    private String getPreferenceName(String flagName) {
        return FLAGGR_SHARED_PREFERENCES_PREFIX + flagName;
    }
}

