/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.zadviser.build;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.common.utils.ArgumentUtils;
import com.compuware.jenkins.common.utils.CLIVersionUtils;
import com.compuware.jenkins.zadviser.Messages;
import com.compuware.jenkins.zadviser.build.RemoteSystemProperties;
import com.compuware.jenkins.zadviser.common.configuration.ZAdviserGlobalConfiguration;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class ZAdviserDownloadData
extends Builder
implements SimpleBuildStep {
    private String connectionId;
    private String credentialsId;
    private String jcl;
    private String unencryptedDataFile;
    private String encryptedDataFile;
    private boolean encryptData = false;
    private boolean uploadData = true;
    private FilePath jclFile;

    @DataBoundConstructor
    public ZAdviserDownloadData(String connectionId, String credentialsId, String jcl, String encryptedDataFile, String unencryptedDataFile) {
        this.connectionId = StringUtils.trimToEmpty((String)connectionId);
        this.credentialsId = StringUtils.trimToEmpty((String)credentialsId);
        this.jcl = StringUtils.trimToEmpty((String)jcl);
        this.encryptedDataFile = StringUtils.trimToEmpty((String)encryptedDataFile);
        this.unencryptedDataFile = StringUtils.trimToEmpty((String)unencryptedDataFile);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getJcl() {
        return this.jcl;
    }

    public String getEncryptedDataFile() {
        return this.encryptedDataFile;
    }

    public String getUnencryptedDataFile() {
        return this.unencryptedDataFile;
    }

    public boolean isEncryptData() {
        return this.encryptData;
    }

    @DataBoundSetter
    public void setEncryptData(boolean encryptData) {
        this.encryptData = encryptData;
    }

    public boolean isUploadData() {
        return this.uploadData;
    }

    @DataBoundSetter
    public void setUploadData(boolean uploadData) {
        this.uploadData = uploadData;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        try {
            String uploadDataFileStr;
            String initialDateRangeStr;
            PrintStream logger = listener.getLogger();
            CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
            assert (launcher != null);
            VirtualChannel vChannel = launcher.getChannel();
            FilePath cliDirectory = new FilePath(vChannel, globalConfig.getTopazCLILocation(launcher));
            String cliVersion = CLIVersionUtils.getCLIVersion((FilePath)cliDirectory, (String)"20.2.1");
            CLIVersionUtils.checkCLICompatibility((String)cliVersion, (String)"20.2.1");
            assert (vChannel != null);
            Properties remoteProperties = (Properties)vChannel.call((Callable)new RemoteSystemProperties());
            String remoteFileSeparator = remoteProperties.getProperty("file.separator");
            boolean isShell = launcher.isUnix();
            String osFile = isShell ? "ZAdviserCLI.sh" : "ZAdviserCLI.bat";
            String cliScriptFile = globalConfig.getTopazCLILocation(launcher) + remoteFileSeparator + osFile;
            logger.println("cliScriptFile: " + cliScriptFile);
            String cliScriptFileRemote = new FilePath(vChannel, cliScriptFile).getRemote();
            logger.println("cliScriptFileRemote: " + cliScriptFileRemote);
            ArgumentListBuilder args = globalConfig.getArgumentBuilder(cliScriptFile, cliVersion, (Item)run.getParent(), this.getCredentialsId(), this.getConnectionId());
            String topazCliWorkspace = workspace.getRemote() + remoteFileSeparator + "TopazCliWkspc" + UUID.randomUUID().toString();
            logger.println("topazCliWorkspace: " + topazCliWorkspace);
            args.add(new String[]{"-data", topazCliWorkspace});
            args.add(new String[]{"-buildStep", "D"});
            ZAdviserGlobalConfiguration zAdviserGlobalConfiguration = ZAdviserGlobalConfiguration.get();
            this.jclFile = workspace.createTextTempFile("jcl", ".txt", this.getJcl());
            String escapedJclFileName = ArgumentUtils.escapeForScript((String)this.jclFile.getRemote());
            logger.println("JCL file path: " + escapedJclFileName);
            args.add(new String[]{"-jclFilePath", escapedJclFileName});
            String unencryptedDataFileStr = this.getUnencryptedDataFile();
            if (StringUtils.isNotBlank((CharSequence)unencryptedDataFileStr)) {
                args.add(new String[]{"-unencryptedDataFile", ArgumentUtils.escapeForScript((String)unencryptedDataFileStr)});
            }
            if (StringUtils.isNotBlank((CharSequence)(initialDateRangeStr = zAdviserGlobalConfiguration.getInitialDateRange()))) {
                args.add(new String[]{"-initialDateRange", initialDateRangeStr});
            }
            if (this.isEncryptData() || this.isUploadData()) {
                String customerId;
                Secret accessKey = zAdviserGlobalConfiguration.getAccessKey();
                if (accessKey != null && StringUtils.isNotBlank((CharSequence)accessKey.getPlainText())) {
                    args.add("-accessKey");
                    args.add(accessKey.getPlainText(), true);
                }
                if (StringUtils.isNotEmpty((CharSequence)(customerId = zAdviserGlobalConfiguration.getCustomerId()))) {
                    args.add(new String[]{"-customerId", customerId});
                }
            }
            if (this.isEncryptData()) {
                String encryptedDataFileStr;
                Secret encryptionKey = zAdviserGlobalConfiguration.getEncryptionKey();
                if (encryptionKey != null && StringUtils.isNotBlank((CharSequence)encryptionKey.getPlainText())) {
                    args.add("-encryptionKey");
                    args.add(encryptionKey.getPlainText(), true);
                }
                if (StringUtils.isNotBlank((CharSequence)(encryptedDataFileStr = this.getEncryptedDataFile()))) {
                    args.add(new String[]{"-encryptedDataFile", ArgumentUtils.escapeForScript((String)encryptedDataFileStr)});
                }
            }
            if (this.isUploadData() && StringUtils.isNotBlank((CharSequence)(uploadDataFileStr = this.isEncryptData() ? this.getEncryptedDataFile() : this.getUnencryptedDataFile()))) {
                args.add(new String[]{"-uploadDataFile", ArgumentUtils.escapeForScript((String)uploadDataFileStr)});
            }
            EnvVars env = run.getEnvironment(listener);
            args.add(new String[]{"-persistData", ArgumentUtils.escapeForScript((String)((String)env.get((Object)"JENKINS_HOME")))});
            FilePath workDir = new FilePath(vChannel, workspace.getRemote());
            workDir.mkdirs();
            int exitValue = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)logger).pwd(workDir).join();
            if (exitValue != 0) {
                throw new AbortException("Call " + osFile + " exited with value = " + exitValue);
            }
            logger.println("Call " + osFile + " exited with value = " + exitValue);
            FilePath topazDataDir = new FilePath(vChannel, topazCliWorkspace);
            topazDataDir.deleteRecursive();
        }
        finally {
            this.cleanUp();
        }
    }

    protected void cleanUp() throws IOException, InterruptedException {
        if (this.jclFile != null) {
            this.jclFile.delete();
        }
    }

    @Symbol(value={"zAdviserDownload"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return Messages.zAdviserDownloadDataDescriptorDisplayName();
        }

        @POST
        public FormValidation doCheckConnectionId(@QueryParameter String connectionId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)connectionId)) {
                return FormValidation.error((String)Messages.checkHostConnectionError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)credentialsId)) {
                return FormValidation.error((String)Messages.checkLoginCredentialsError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckJcl(@QueryParameter String jcl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)jcl)) {
                return FormValidation.error((String)Messages.checkJclError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckEncryptedDataFile(@QueryParameter String encryptedDataFile) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)encryptedDataFile)) {
                return FormValidation.error((String)Messages.checkEncryptedDataFileError());
            }
            ZAdviserGlobalConfiguration zAdviserGlobalConfig = ZAdviserGlobalConfiguration.get();
            Secret accessKey = zAdviserGlobalConfig.getAccessKey();
            if (accessKey == null) {
                return FormValidation.error((String)Messages.checkMissingAccessKeyError());
            }
            Secret encryptionKey = zAdviserGlobalConfig.getEncryptionKey();
            if (encryptionKey == null) {
                return FormValidation.error((String)Messages.checkMissingEncryptionKeyError());
            }
            String customerId = zAdviserGlobalConfig.getCustomerId();
            if (StringUtils.isBlank((CharSequence)customerId)) {
                return FormValidation.error((String)Messages.checkMissingCustomerIdError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUnencryptedDataFile(@QueryParameter String unencryptedDataFile) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)unencryptedDataFile)) {
                return FormValidation.error((String)Messages.checkUnencryptedDataFileError());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
            HostConnection[] hostConnections = globalConfig.getHostConnections();
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (HostConnection connection : hostConnections) {
                boolean isSelected = false;
                if (connectionId != null) {
                    isSelected = connectionId.matches(connection.getConnectionId());
                }
                model.add((Object)new ListBoxModel.Option(connection.getDescription() + " [" + connection.getHostPort() + ']', connection.getConnectionId(), isSelected));
            }
            return model;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (StandardUsernamePasswordCredentials c : creds) {
                boolean isSelected = false;
                if (credentialsId != null) {
                    isSelected = credentialsId.matches(c.getId());
                }
                String description = Util.fixEmptyAndTrim((String)c.getDescription());
                model.add((Object)new ListBoxModel.Option(c.getUsername() + (description != null ? " (" + description + ')' : ""), c.getId(), isSelected));
            }
            return model;
        }

        private InputStream readResource(String fileName) {
            return ZAdviserDownloadData.class.getClassLoader().getResourceAsStream(fileName);
        }

        public String getDefaultJcl() {
            StringBuilder builder = new StringBuilder();
            try (InputStream stream = this.readResource("defaultJcl.jcl");
                 Scanner scanner = new Scanner(stream, "UTF-8");){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    builder.append(line);
                    builder.append('\n');
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return builder.toString();
        }
    }
}

