/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.build;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.compuware.jenkins.build.CodeCoverageScanner;
import com.compuware.jenkins.build.Messages;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CodeCoverageBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger("hudson.CodeCoverageBuilder");
    private final String m_connectionId;
    private final String m_credentialsId;
    private final String m_analysisPropertiesPath;
    private final String m_analysisProperties;

    @DataBoundConstructor
    public CodeCoverageBuilder(String connectionId, String credentialsId, String analysisPropertiesPath, String analysisProperties) {
        this.m_connectionId = StringUtils.trimToEmpty((String)connectionId);
        this.m_credentialsId = StringUtils.trimToEmpty((String)credentialsId);
        this.m_analysisPropertiesPath = StringUtils.trimToEmpty((String)analysisPropertiesPath);
        this.m_analysisProperties = StringUtils.trimToEmpty((String)analysisProperties);
    }

    public String getConnectionId() {
        return this.m_connectionId;
    }

    public String getCredentialsId() {
        return this.m_credentialsId;
    }

    public String getAnalysisPropertiesPath() {
        return this.m_analysisPropertiesPath;
    }

    public String getAnalysisProperties() {
        return this.m_analysisProperties;
    }

    public CodeCoverageDescriptorImpl getDescriptor() {
        return (CodeCoverageDescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        CodeCoverageScanner scanner = new CodeCoverageScanner(this);
        scanner.perform(run, workspace, launcher, listener);
    }

    @Extension
    public static final class CodeCoverageDescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public CodeCoverageDescriptorImpl() {
            super(CodeCoverageBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.descriptorDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public String getDefaultAnalysisProperties() {
            return Messages.defaultAnalysisProperties();
        }

        public FormValidation doCheckConnectionId(@QueryParameter String connectionId) {
            String tempValue = StringUtils.trimToEmpty((String)connectionId);
            if (tempValue.isEmpty()) {
                return FormValidation.error((String)Messages.checkHostConnectionError());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId) {
            String tempValue = StringUtils.trimToEmpty((String)credentialsId);
            if (tempValue.isEmpty()) {
                return FormValidation.error((String)Messages.checkLoginCredentialsError());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
            HostConnection[] hostConnections = globalConfig.getHostConnections();
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (HostConnection connection : hostConnections) {
                boolean isSelected = false;
                if (connectionId != null) {
                    isSelected = connectionId.matches(connection.getConnectionId());
                }
                model.add((Object)new ListBoxModel.Option(connection.getDescription() + " [" + connection.getHostPort() + ']', connection.getConnectionId(), isSelected));
            }
            return model;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            List creds = CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (StandardCredentials c : creds) {
                boolean isSelected = false;
                if (credentialsId != null) {
                    isSelected = credentialsId.matches(c.getId());
                }
                String description = Util.fixEmptyAndTrim((String)c.getDescription());
                try {
                    model.add((Object)new ListBoxModel.Option(CpwrGlobalConfiguration.get().getCredentialsUser(c) + (description != null ? " (" + description + ')' : ""), c.getId(), isSelected));
                }
                catch (AbortException e) {
                    LOGGER.log(Level.WARNING, e.getMessage());
                }
            }
            return model;
        }
    }
}

