/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.strobe;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.strobe.Messages;
import com.compuware.jenkins.strobe.StrobeMeasurementRunner;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

public class StrobeMeasurementBuilder
extends Builder
implements SimpleBuildStep {
    private static final String EQUAL = "=";
    private String connectionId;
    private String credentialsId;
    private String requestType;
    private String jobName;
    private String cesUrl;
    private String system;
    private String tags;
    private String profileName;
    private String emailto;
    private String duration;
    private String samples;
    private String limit;
    private String finalAction;
    private String hlq;
    private String transactionId;
    private String method;
    private String url;
    private String headers;
    private String body;

    @DataBoundConstructor
    public StrobeMeasurementBuilder(String connectionId, String credentialsId, String requestType, String jobName) {
        this.connectionId = StringUtils.trimToEmpty((String)connectionId);
        this.credentialsId = StringUtils.trimToEmpty((String)credentialsId);
        this.requestType = StringUtils.trimToEmpty((String)requestType);
        this.jobName = StringUtils.trimToEmpty((String)jobName);
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        HostConnection hostConnection = globalConfig.getHostConnection(connectionId);
        if (hostConnection != null) {
            this.cesUrl = StringUtils.trimToEmpty((String)hostConnection.getCesUrl());
            this.system = StringUtils.trimToEmpty((String)hostConnection.getDescription());
        }
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCesUrl() {
        return this.cesUrl;
    }

    public String getSystem() {
        return this.system;
    }

    public String getTags() {
        return this.tags;
    }

    @DataBoundSetter
    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getProfileName() {
        return this.profileName;
    }

    @DataBoundSetter
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getEmailto() {
        return this.emailto;
    }

    @DataBoundSetter
    public void setEmailto(String emailto) {
        this.emailto = emailto;
    }

    public String getDuration() {
        return this.duration;
    }

    @DataBoundSetter
    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getSamples() {
        return this.samples;
    }

    @DataBoundSetter
    public void setSamples(String samples) {
        this.samples = samples;
    }

    public String getLimit() {
        return this.limit;
    }

    @DataBoundSetter
    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getFinalAction() {
        return this.finalAction;
    }

    @DataBoundSetter
    public void setFinalAction(String finalAction) {
        this.finalAction = finalAction;
    }

    public String getHlq() {
        return this.hlq;
    }

    @DataBoundSetter
    public void setHlq(String hlq) {
        this.hlq = hlq;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @DataBoundSetter
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getMethod() {
        return this.method;
    }

    @DataBoundSetter
    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getHeaders() {
        return this.headers;
    }

    @DataBoundSetter
    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getBody() {
        return this.body;
    }

    @DataBoundSetter
    public void setBody(String body) {
        this.body = body;
    }

    public void perform(Run<?, ?> build, FilePath workspaceFilePath, Launcher launcher, TaskListener listener) throws AbortException {
        try {
            List credentials = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)build.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)this.credentialsId)));
            Secret token = null;
            if (credentials != null && credentials.size() > 0) {
                StringCredentials credential = (StringCredentials)credentials.get(0);
                token = credential.getSecret();
            }
            this.validateParameters(launcher, listener, (Item)build.getParent());
            StrobeMeasurementRunner runner = new StrobeMeasurementRunner(this);
            boolean success = runner.run(build, launcher, workspaceFilePath, listener, token);
            if (!success) {
                throw new AbortException(Messages.strobeMeasurementFailure());
            }
            listener.getLogger().println(Messages.strobeMeasurementSuccess());
            listener.getLogger().println("When the measurement is complete, view the generated profile at " + this.getCesUrl() + "/istrobe/jsp/myStrobe/myStrobe.jsp");
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            throw new AbortException();
        }
    }

    public void validateParameters(Launcher launcher, TaskListener listener, Item project) {
        if (this.getConnectionId().isEmpty()) {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.hostConnection()));
        }
        if (this.getCredentialsId().isEmpty()) {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.credentials()));
        }
        if (this.getRequestType().isEmpty()) {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.requestType()));
        }
        listener.getLogger().println(Messages.requestType() + EQUAL + this.getRequestType());
        if (this.getJobName().isEmpty()) {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.jobName()));
        }
        listener.getLogger().println(Messages.jobName() + EQUAL + this.getJobName());
        if (!this.getCesUrl().isEmpty()) {
            if (!this.cesUrl.startsWith("http")) {
                throw new IllegalArgumentException(Messages.errorInvalidCesUrl());
            }
        } else {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.errorMissingCesUrl()));
        }
        listener.getLogger().println(Messages.cesUrl() + EQUAL + this.getCesUrl());
        if (this.getSystem().isEmpty()) {
            throw new IllegalArgumentException(Messages.errorMissingParameter(Messages.errorMissingSystem()));
        }
        listener.getLogger().println(Messages.system() + EQUAL + this.getSystem());
        if (!this.getTags().isEmpty()) {
            listener.getLogger().println(Messages.tags() + EQUAL + this.getTags());
        }
        if (!this.getProfileName().isEmpty()) {
            listener.getLogger().println(Messages.profileName() + EQUAL + this.getProfileName());
        }
        if (!this.getEmailto().isEmpty()) {
            listener.getLogger().println(Messages.emailTo() + EQUAL + this.getEmailto());
        }
        if (!this.getDuration().isEmpty()) {
            listener.getLogger().println(Messages.duration() + EQUAL + this.getDuration());
        }
        if (!this.getSamples().isEmpty()) {
            listener.getLogger().println(Messages.samples() + EQUAL + this.getSamples());
        }
        if (!this.getLimit().isEmpty()) {
            listener.getLogger().println(Messages.limit() + EQUAL + this.getLimit());
        }
        if (!this.getFinalAction().isEmpty()) {
            if (this.getFinalAction().equals("nolimit")) {
                listener.getLogger().println(Messages.finalAction() + EQUAL + "continue");
            } else {
                listener.getLogger().println(Messages.finalAction() + EQUAL + this.getFinalAction());
            }
        }
        if (!this.getHlq().isEmpty()) {
            listener.getLogger().println(Messages.hlq() + EQUAL + this.getHlq());
        }
        if (!this.getTransactionId().isEmpty()) {
            listener.getLogger().println(Messages.transactionId() + EQUAL + this.getTransactionId());
        }
        if (!this.getUrl().isEmpty()) {
            if (!this.getMethod().isEmpty()) {
                listener.getLogger().println(Messages.method() + EQUAL + this.getMethod());
            }
            listener.getLogger().println(Messages.url() + EQUAL + this.getUrl());
            if (!this.getHeaders().isEmpty()) {
                listener.getLogger().println(Messages.headers() + EQUAL + this.getHeaders());
            }
            if (!this.getBody().isEmpty()) {
                listener.getLogger().println(Messages.body() + EQUAL + this.getBody());
            }
        }
    }

    @Symbol(value={"strobeMeasurement"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.displayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @POST
        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
            HostConnection[] hostConnections = globalConfig.getHostConnections();
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (HostConnection connection : hostConnections) {
                boolean isSelected = false;
                if (connectionId != null) {
                    isSelected = connectionId.matches(connection.getConnectionId());
                }
                model.add((Object)new ListBoxModel.Option(connection.getDescription() + " [" + connection.getHostPort() + ']', connection.getConnectionId(), isSelected));
            }
            return model;
        }

        @POST
        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            List creds = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
            StandardListBoxModel model = new StandardListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (StringCredentials c : creds) {
                boolean isSelected = false;
                if (credentialsId != null) {
                    isSelected = credentialsId.matches(c.getId());
                }
                String description = StringUtils.trimToEmpty((String)c.getDescription());
                model.add((Object)new ListBoxModel.Option(description, c.getId(), isSelected));
            }
            return model;
        }

        @GET
        public FormValidation doCheckConnectionId(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.checkConnectionIdError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCredentialsId(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.checkLoginCredentialError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckJobName(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.checkJobNameError());
            }
            return FormValidation.ok();
        }
    }
}

