/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.util;

import com.compuware.ispw.restapi.action.IAction;
import com.compuware.ispw.restapi.action.IspwAction;
import com.compuware.ispw.restapi.action.IspwCommand;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.log4j.Logger;

public class ReflectUtils {
    private static Logger logger = Logger.getLogger(ReflectUtils.class);

    public static void reflectSetter(Object object, String name, Object value) {
        List fields = FieldUtils.getAllFieldsList(object.getClass());
        for (Field field : fields) {
            String fieldName;
            String jsonName = fieldName = field.getName();
            if (field.isAnnotationPresent(XmlElement.class)) {
                XmlElement xmlElement = field.getAnnotation(XmlElement.class);
                jsonName = xmlElement.name();
            }
            logger.info((Object)("json.name=" + jsonName + ", fieldName=" + fieldName + ", type=" + field.getType().getName() + ", value=" + value));
            if (!jsonName.equals(name) && !fieldName.equals(name)) continue;
            try {
                BeanUtils.setProperty((Object)object, (String)fieldName, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn((Object)("Property key " + name + "(" + jsonName + ") is invalid, cannot be set to class " + object.getClass().getName() + "as value [" + value + "])"));
            }
        }
    }

    public static String reflectGetter(Object object, String name) {
        String value = "";
        List fields = FieldUtils.getAllFieldsList(object.getClass());
        for (Field field : fields) {
            String fieldName;
            String jsonName = fieldName = field.getName();
            if (field.isAnnotationPresent(XmlElement.class)) {
                XmlElement xmlElement = field.getAnnotation(XmlElement.class);
                jsonName = xmlElement.name();
            }
            if (!jsonName.equals(name)) continue;
            try {
                value = BeanUtils.getProperty((Object)object, (String)fieldName);
                logger.info((Object)("json.name=" + jsonName + ", type=" + field.getType().getName() + ", value=" + value));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.warn((Object)("Property key " + name + "(" + jsonName + ") is invalid, cannot get value for class " + object.getClass().getName()));
            }
        }
        return value;
    }

    public static String[] listPublishedCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        List fields = FieldUtils.getAllFieldsList(IspwCommand.class);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(IspwAction.class)) continue;
            IspwAction ispwAction = field.getAnnotation(IspwAction.class);
            Class<?> clazz = ispwAction.clazz();
            boolean isExposed = ispwAction.exposed();
            String command = "";
            try {
                command = (String)FieldUtils.readStaticField((Field)field);
                if (!isExposed) continue;
                commands.add(command);
            }
            catch (IllegalAccessException e) {
                String message = String.format("Failed to read command value in field: %s, clazz: %s", command, clazz.getName());
                logger.error((Object)message, (Throwable)e);
            }
        }
        return commands.toArray(new String[commands.size()]);
    }

    public static Class<?> getCommandClass(String command) {
        Class<?> clazz = null;
        List fields = FieldUtils.getAllFieldsList(IspwCommand.class);
        for (Field field : fields) {
            String message;
            if (!field.isAnnotationPresent(IspwAction.class)) continue;
            String definedCommand = "";
            try {
                definedCommand = (String)FieldUtils.readStaticField((Field)field);
            }
            catch (IllegalAccessException e) {
                message = String.format("Failed to read command value in field: %s", command);
                logger.error((Object)message, (Throwable)e);
            }
            if (!definedCommand.equals(command)) continue;
            IspwAction ispwAction = field.getAnnotation(IspwAction.class);
            clazz = ispwAction.clazz();
            message = String.format("Reflect to get command %s -> class %s", command, clazz.getName());
            logger.info((Object)message);
        }
        return clazz;
    }

    public static IAction createAction(String command, PrintStream log) {
        IAction action = null;
        Class<?> clazz = ReflectUtils.getCommandClass(command);
        String clazzName = "[No match class]";
        String actionName = "[No match action]";
        if (clazz != null) {
            clazzName = clazz.getName();
            try {
                action = (IAction)ConstructorUtils.invokeConstructor(clazz, (Object)log);
                if (action != null) {
                    actionName = action.toString();
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String message = String.format("Failed to instantiate command: %s from action class: %s", command, clazzName);
                log.println(message);
                logger.error((Object)message, (Throwable)e);
            }
        }
        String message = String.format("Reflect to instantiate command %s -> Class %s -> instance %s", command, clazzName, actionName);
        logger.info((Object)message);
        return action;
    }

    public static boolean isActionInstantiated(IAction iAction) {
        return iAction != null;
    }

    public static <T> T newInstance(Class<T> clazz) {
        T t = null;
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return t;
        }
    }
}

