/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.auth;

import com.compuware.ispw.restapi.HttpRequestGlobalConfig;
import com.compuware.ispw.restapi.auth.Authenticator;
import com.compuware.ispw.restapi.util.HttpClientUtil;
import com.compuware.ispw.restapi.util.RequestAction;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FormAuthentication
extends AbstractDescribableImpl<FormAuthentication>
implements Authenticator {
    private static final long serialVersionUID = -4370238820437831639L;
    private final String keyName;
    private final List<RequestAction> actions;

    @DataBoundConstructor
    public FormAuthentication(String keyName, List<RequestAction> actions) {
        this.keyName = keyName;
        this.actions = actions == null ? new ArrayList() : actions;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    public List<RequestAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, PrintStream logger) throws IOException, InterruptedException {
        CloseableHttpClient client = clientBuilder.build();
        HttpClientUtil clientUtil = new HttpClientUtil();
        for (RequestAction requestAction : this.actions) {
            HttpRequestBase method = clientUtil.createRequestBase(requestAction);
            HttpResponse execute = clientUtil.execute((HttpClient)client, context, method, logger);
            if (execute.getStatusLine().getStatusCode() < 400 || execute.getStatusLine().getStatusCode() > 599) continue;
            throw new IllegalStateException("Error doing authentication");
        }
        return client;
    }

    @Extension
    public static class FormAuthenticationDescriptor
    extends Descriptor<FormAuthentication> {
        public FormValidation doCheckKeyName(@QueryParameter String value) {
            return HttpRequestGlobalConfig.validateKeyName(value);
        }

        public String getDisplayName() {
            return "Form Authentication";
        }
    }
}

