/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.MultiTaskInfoResponse;
import com.compuware.ispw.model.rest.TransferTaskInfo;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractPostAction;
import com.compuware.ispw.restapi.action.IAction;
import com.compuware.ispw.restapi.util.ReflectUtils;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class TransferTaskAction
extends AbstractPostAction
implements IAction {
    private static final String contextPath = "/ispw/{srid}/assignments/{assignmentId}/tasks/transfer?level={level}&mname={mname}&mtype={mtype}&taskId={taskId}";

    public TransferTaskAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        String[] lines;
        IspwRequestBean bean = new IspwRequestBean();
        IspwContextPathBean ispwContextPathBean = new IspwContextPathBean();
        ispwContextPathBean.setSrid(srid);
        bean.setIspwContextPathBean(ispwContextPathBean);
        String path = contextPath.replace("{srid}", srid);
        TransferTaskInfo transferTaskInfo = new TransferTaskInfo();
        bean.setJsonObject(transferTaskInfo);
        for (String line : lines = ispwRequestBody.split("\n")) {
            int indexOfEqualSign;
            if ((line = StringUtils.trimToEmpty((String)line)).startsWith("#") || (indexOfEqualSign = line.indexOf("=")) == -1) continue;
            String name = StringUtils.trimToEmpty((String)line.substring(0, indexOfEqualSign));
            String value = StringUtils.trimToEmpty((String)line.substring(indexOfEqualSign + 1, line.length()));
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if (name.equals("assignmentId")) {
                path = path.replace("{assignmentId}", value);
                ispwContextPathBean.setAssignmentId(value);
                continue;
            }
            if (name.equals("level")) {
                path = path.replace("{level}", value);
                ispwContextPathBean.setLevel(value);
                continue;
            }
            if (name.equals("mname")) {
                path = path.replace("{mname}", value);
                ispwContextPathBean.setMname(value);
                continue;
            }
            if (name.equals("mtype")) {
                path = path.replace("{mtype}", value);
                ispwContextPathBean.setMtype(value);
                continue;
            }
            if (name.equals("taskId")) {
                path = path.replace("{taskId}", value);
                ispwContextPathBean.setTaskId(value);
                continue;
            }
            ReflectUtils.reflectSetter(transferTaskInfo, name, value);
        }
        path = path.replace("level={level}", "");
        path = path.replace("&mname={mname}", "");
        path = path.replace("&mtype={mtype}", "");
        path = path.replace("&taskId={taskId}", "");
        bean.setContextPath(path);
        JsonProcessor jsonGenerator = new JsonProcessor();
        String jsonRequest = jsonGenerator.generate(transferTaskInfo);
        bean.setJsonRequest(jsonRequest);
        return bean;
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        String message = String.format("Transfering tasks for assignment %s at (level=%s, mname=%s, mtype=%s, taskId=%s)", ispwContextPathBean.getAssignmentId(), ispwContextPathBean.getLevel(), ispwContextPathBean.getMname(), ispwContextPathBean.getMtype(), ispwContextPathBean.getTaskId());
        logger.println(message);
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        MultiTaskInfoResponse taskResp = new JsonProcessor().parse(responseJson, MultiTaskInfoResponse.class);
        logger.println("Transfer task response message: " + taskResp.getMessage());
        return taskResp;
    }
}

