/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.MultiTaskInfoResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractPostAction;
import com.compuware.ispw.restapi.action.IAction;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class RemoveFromReleaseAction
extends AbstractPostAction
implements IAction {
    private static final String CONTEXT_PATH = "/ispw/{srid}/releases/{releaseId}/tasks/remove?level={level}&mname={mname}&mtype={mtype}&taskId={taskId}";

    public RemoveFromReleaseAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        String[] lines;
        IspwRequestBean bean = new IspwRequestBean();
        IspwContextPathBean ispwContextPathBean = new IspwContextPathBean();
        ispwContextPathBean.setSrid(srid);
        bean.setIspwContextPathBean(ispwContextPathBean);
        String path = CONTEXT_PATH.replace("{srid}", srid);
        for (String line : lines = ispwRequestBody.split("\n")) {
            int indexOfEqualSign;
            if ((line = StringUtils.trimToEmpty((String)line)).startsWith("#") || (indexOfEqualSign = line.indexOf("=")) == -1) continue;
            String name = StringUtils.trimToEmpty((String)line.substring(0, indexOfEqualSign));
            String value = StringUtils.trimToEmpty((String)line.substring(indexOfEqualSign + 1, line.length()));
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if (name.equals("releaseId")) {
                path = path.replace("{releaseId}", value);
                ispwContextPathBean.setReleaseId(value);
                continue;
            }
            if (name.equals("level")) {
                path = path.replace("{level}", value);
                ispwContextPathBean.setLevel(value);
                continue;
            }
            if (name.equals("mname")) {
                path = path.replace("{mname}", value);
                ispwContextPathBean.setMname(value);
                continue;
            }
            if (name.equals("mtype")) {
                path = path.replace("{mtype}", value);
                ispwContextPathBean.setMtype(value);
                continue;
            }
            if (!name.equals("taskId")) continue;
            path = path.replace("{taskId}", value);
            ispwContextPathBean.setTaskId(value);
        }
        path = path.replace("level={level}", "");
        path = path.replace("&mname={mname}", "");
        path = path.replace("&mtype={mtype}", "");
        path = path.replace("&taskId={taskId}", "");
        bean.setContextPath(path);
        return bean;
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        String message = String.format("Removing tasks for release %s at (level=%s, mname=%s, mtype=%s, taskId=%s)", ispwContextPathBean.getReleaseId(), ispwContextPathBean.getLevel(), ispwContextPathBean.getMname(), ispwContextPathBean.getMtype(), ispwContextPathBean.getTaskId());
        logger.println(message);
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        MultiTaskInfoResponse taskResp = new JsonProcessor().parse(responseJson, MultiTaskInfoResponse.class);
        logger.println("Remove from release response message: " + taskResp.getMessage());
        return taskResp;
    }
}

