/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.TaskResponse;
import com.compuware.ispw.restapi.Constants;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import com.compuware.ispw.restapi.util.RestApiUtils;
import java.io.PrintStream;

public class PromoteReleaseAction
extends SetInfoPostAction {
    private static final String[] defaultProps = new String[]{"releaseId", "level"};
    private static final String contextPath = "/ispw/{srid}/releases/{releaseId}/tasks/promote?level={level}&mname={mname}&mtype={mtype}";

    public static final String getDefaultProps() {
        return RestApiUtils.join(Constants.LINE_SEPARATOR, defaultProps, true);
    }

    public PromoteReleaseAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        return this.getIspwRequestBean(srid, ispwRequestBody, webhookToken, contextPath);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        logger.println("Promoting tasks in Release " + ispwContextPathBean.getReleaseId() + " at level " + ispwContextPathBean.getLevel());
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        TaskResponse taskResp = new JsonProcessor().parse(responseJson, TaskResponse.class);
        logger.println("Set " + taskResp.getSetId() + " created to promote Release " + ispwRequestBean.getIspwContextPathBean().getReleaseId());
        return taskResp;
    }
}

