/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.ContainerListInfo;
import com.compuware.ispw.model.rest.ContainerListResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractGetAction;
import com.compuware.ispw.restapi.util.RestApiUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class GetContainerListAction
extends AbstractGetAction {
    private static final String[] defaultProps = new String[]{"userId", "containerId", "containerType", "application", "owner", "description", "refNumber", "releaseId", "stream", "path", "tag", "includeClosedContainers"};
    private static final String contextPath = "/ispw/{srid}/containers/list?userId={userId}&containerId={containerId}&containerType={containerType}&application={application}&owner={owner}&description={description}&refNumber={refNumber}&releaseId={releaseId}&stream={stream}&path={path}&tag={tag}&includeClosedContainers={includeClosedContainers}";

    public GetContainerListAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        List<String> pathTokens = Arrays.asList(defaultProps);
        IspwRequestBean ispwRequestBean = super.getIspwRequestBean(srid, ispwRequestBody, contextPath, pathTokens);
        String path = ispwRequestBean.getContextPath();
        path = path.replace("userId={userId}", "");
        path = path.replace("containerId={containerId}", "");
        path = path.replace("containerType={containerType}", "");
        path = path.replace("application={application}", "");
        path = path.replace("owner={owner}", "");
        path = path.replace("description={description}", "");
        path = path.replace("refNumber={refNumber}", "");
        path = path.replace("releaseId={releaseId}", "");
        path = path.replace("stream={stream}", "");
        path = path.replace("path={path}", "");
        path = path.replace("tag={tag}", "");
        path = path.replace("includeClosedContainers={includeClosedContainers}", "");
        if ((path = path.replaceAll("[&]+", "&")).endsWith("&")) {
            path = path.substring(0, path.length() - 1);
        }
        ispwRequestBean.setContextPath(path);
        return ispwRequestBean;
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        logger.println("Get the container list information");
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        String fixedResponseJson = RestApiUtils.fixCesContainerListResponseJson(responseJson);
        ContainerListResponse listResponse = new JsonProcessor().parse(fixedResponseJson, ContainerListResponse.class);
        if (listResponse != null) {
            for (ContainerListInfo containerListInfo : listResponse.getContainerList()) {
                logger.println(" ");
                logger.println("Application: " + containerListInfo.getApplication());
                logger.println("Container ID: " + containerListInfo.getContainerId());
                logger.println("Container type: " + containerListInfo.getContainerType());
                logger.println("Description: " + containerListInfo.getDescription());
                logger.println("Owner: " + containerListInfo.getOwner());
                logger.println("Path: " + containerListInfo.getPath());
                logger.println("Reference number: " + containerListInfo.getWorkRefNumber());
                logger.println("Release ID: " + containerListInfo.getReleaseId());
                logger.println("Stream: " + containerListInfo.getStream());
                logger.println("Tag: " + containerListInfo.getUserTag());
            }
        }
        return listResponse;
    }
}

