/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.AssignmentInfo;
import com.compuware.ispw.model.rest.AssignmentResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractPostAction;
import java.io.PrintStream;

public class CreateAssignmentAction
extends AbstractPostAction {
    private static final String[] defaultProps = new String[]{"stream", "application", "defaultPath", "description", "owner", "assignmentPrefix"};
    private static final String contextPath = "/ispw/{srid}/assignments";

    public CreateAssignmentAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        AssignmentInfo assignmentInfo = new AssignmentInfo();
        return super.getIspwRequestBean(srid, ispwRequestBody, contextPath, assignmentInfo);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        AssignmentInfo assignmentInfo = (AssignmentInfo)jsonObject;
        logger.println("Creating assignment " + assignmentInfo.getStream() + "/" + assignmentInfo.getApplication() + "/" + assignmentInfo.getDefaultPath() + " with description - " + assignmentInfo.getDescription());
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        AssignmentResponse assignResp = new JsonProcessor().parse(responseJson, AssignmentResponse.class);
        logger.println("Created Assignment " + assignResp.getAssignmentId());
        return assignResp;
    }
}

