/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.ReleaseResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class CancelReleaseAction
extends SetInfoPostAction {
    private static final String[] defaultProps = new String[]{"releaseId", "runtimeConfiguration"};
    private static final String contextPath = "/ispw/{srid}/releases/{releaseId}/cancel";

    public CancelReleaseAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        return this.getIspwRequestBean(srid, ispwRequestBody, webhookToken, contextPath);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        String msg = String.format("Cancel release %s", ispwContextPathBean.getReleaseId());
        logger.println(msg);
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        ReleaseResponse releaseResp = new JsonProcessor().parse(responseJson, ReleaseResponse.class);
        logger.println("Cancel release " + ispwRequestBean.getIspwContextPathBean().getReleaseId() + " is submitted. " + StringUtils.trimToEmpty((String)releaseResp.getMessage()));
        return releaseResp;
    }
}

