/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.AssignmentResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class CancelAssignmentAction
extends SetInfoPostAction {
    private static final String[] defaultProps = new String[]{"assignmentId", "runtimeConfiguration"};
    private static final String contextPath = "/ispw/{srid}/assignments/{assignmentId}/cancel";

    public CancelAssignmentAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        return this.getIspwRequestBean(srid, ispwRequestBody, webhookToken, contextPath);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        String msg = String.format("Cancel assignment %s", ispwContextPathBean.getAssignmentId());
        logger.println(msg);
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        AssignmentResponse assignResp = new JsonProcessor().parse(responseJson, AssignmentResponse.class);
        logger.println("Cancel assignment " + ispwRequestBean.getIspwContextPathBean().getAssignmentId() + " is submitted. " + StringUtils.trimToEmpty((String)assignResp.getMessage()));
        return assignResp;
    }
}

