/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.compuware.ces.communications.service.data.EventCallback;
import com.compuware.ces.model.BasicAuthentication;
import com.compuware.ces.model.HttpHeader;
import com.compuware.ispw.model.rest.AssignmentInfo;
import com.compuware.ispw.model.rest.SetInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class JsonProcessor {
    private static Logger logger = Logger.getLogger(JsonProcessor.class);

    public String generate(Object object) {
        String json = "{}";
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
            StringWriter stringWriter = new StringWriter();
            mapper.writeValue((Writer)stringWriter, object);
            json = stringWriter.toString();
        }
        catch (Exception x) {
            logger.error((Object)x.getMessage(), (Throwable)x);
        }
        return json;
    }

    public <T> T parse(String json, Class<T> clazz) {
        Object object = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writerWithDefaultPrettyPrinter();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
            object = mapper.readValue(json, clazz);
        }
        catch (Exception x) {
            logger.error((Object)x.getMessage(), (Throwable)x);
        }
        return (T)object;
    }

    public void test() {
        try {
            String body = "{\"text\":\"Generated!\"}";
            String encodeBody = URLEncoder.encode(body, "UTF-8");
            SetInfo setInfo = new SetInfo();
            setInfo.setRuntimeConfig("TPZP");
            setInfo.setExecStat("I");
            ArrayList<EventCallback> events = new ArrayList<EventCallback>();
            EventCallback event = new EventCallback();
            event.setName("complete");
            event.setUrl("http://localhost:8080/jenkins/ispw-webhook-step/wait");
            event.setBody(encodeBody);
            events.add(event);
            setInfo.setEventCallbacks(events);
            ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
            HttpHeader httpHeader = new HttpHeader();
            httpHeader.setName("Jenkins-Crumb");
            httpHeader.setValue("no-security");
            httpHeaders.add(httpHeader);
            event.setHttpHeaders(httpHeaders);
            BasicAuthentication auth = new BasicAuthentication();
            auth.setUsername("admin");
            auth.setPassword("library");
            event.setCredentials(auth);
            String json = this.generate(setInfo);
            logger.info((Object)("setInfo json=" + json));
            SetInfo setInfo2 = this.parse(json, SetInfo.class);
            logger.info((Object)("setInfo2=" + ReflectionToStringBuilder.toString((Object)setInfo2, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
            String jsonAssignInfo = "{\"stream\":\"PLAY\",\"application\":\"PLAY\",\"defaultPath\":\"DEV2\",\"description\":\"JkGen\",\"owner\":\"PMISVZ0\",\"refNumber\":\" \",\"releaseId\":\" \",\"userTag\":\" \",\"assignmentId\":\"PLAY000313\"}";
            AssignmentInfo assignInfo = this.parse(jsonAssignInfo, AssignmentInfo.class);
            logger.info((Object)("assignInfo=" + ReflectionToStringBuilder.toString((Object)assignInfo, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)));
        }
        catch (Exception x) {
            logger.error((Object)x.getMessage(), (Throwable)x);
        }
    }

    public static void main(String[] args) {
        JsonProcessor generator = new JsonProcessor();
        generator.test();
    }
}

