/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.compuware.ispw.git.GitToIspwUtils;
import com.compuware.ispw.model.changeset.ProgramList;
import com.compuware.ispw.model.rest.BuildResponse;
import com.compuware.ispw.model.rest.SetInfoResponse;
import com.compuware.ispw.model.rest.TaskInfo;
import com.compuware.ispw.model.rest.TaskListResponse;
import com.compuware.ispw.model.rest.TaskResponse;
import com.compuware.ispw.restapi.HttpMode;
import com.compuware.ispw.restapi.HttpRequestExecution;
import com.compuware.ispw.restapi.HttpRequestGlobalConfig;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.MimeType;
import com.compuware.ispw.restapi.ResponseContentSupplier;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.WebhookTokenManager;
import com.compuware.ispw.restapi.action.GenerateTaskAction;
import com.compuware.ispw.restapi.action.GenerateTasksInAssignmentAction;
import com.compuware.ispw.restapi.action.GenerateTasksInReleaseAction;
import com.compuware.ispw.restapi.action.IAction;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import com.compuware.ispw.restapi.auth.BasicDigestAuthentication;
import com.compuware.ispw.restapi.auth.FormAuthentication;
import com.compuware.ispw.restapi.util.HttpClientUtil;
import com.compuware.ispw.restapi.util.HttpRequestNameValuePair;
import com.compuware.ispw.restapi.util.Operation;
import com.compuware.ispw.restapi.util.ReflectUtils;
import com.compuware.ispw.restapi.util.RestApiUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IspwRestApiRequest
extends Builder {
    @Nonnull
    private String url = "";
    private Boolean ignoreSslErrors = false;
    private HttpMode httpMode = DescriptorImpl.httpMode;
    private String httpProxy = "";
    private Boolean passBuildParameters = DescriptorImpl.passBuildParameters;
    private String validResponseCodes = "100:399";
    private String validResponseContent = "";
    private MimeType acceptType = DescriptorImpl.acceptType;
    private MimeType contentType = DescriptorImpl.contentType;
    private String outputFile = "";
    private Integer timeout = 0;
    private String requestBody = "";
    private String authentication = "";
    private String token = "";
    private List<HttpRequestNameValuePair> customHeaders = DescriptorImpl.customHeaders;
    private String connectionId = "";
    private String credentialsId = "";
    private String ispwAction = "";
    private String ispwRequestBody = "#The following messages are commented out to show how to use the 'Request' field.\n#Click on the help button to the right of the screen for examples of how to populate this field based on 'Action' type\n#\n#For example, if you select GenerateTasksInAssignment for 'Action' field,\n# you may populate the following properties in 'Request' field.\n# The property value should be based on your own container ID and level.\n#\n#assignmentId=PLAY000313\n#level=STG2\n";
    private Boolean consoleLogResponseBody = DescriptorImpl.consoleLogResponseBody;
    private Boolean skipWaitingForSet = DescriptorImpl.skipWaitingForSet;

    @DataBoundConstructor
    public IspwRestApiRequest() {
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public Boolean getIgnoreSslErrors() {
        return this.ignoreSslErrors;
    }

    public HttpMode getHttpMode() {
        return this.httpMode;
    }

    public String getIspwAction() {
        return this.ispwAction;
    }

    @DataBoundSetter
    public void setIspwAction(String ispwAction) {
        this.ispwAction = ispwAction;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @DataBoundSetter
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getIspwRequestBody() {
        return this.ispwRequestBody;
    }

    @DataBoundSetter
    public void setIspwRequestBody(String ispwRequestBody) {
        this.ispwRequestBody = ispwRequestBody;
    }

    public String getToken() {
        return this.token;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public Boolean getPassBuildParameters() {
        return this.passBuildParameters;
    }

    @Nonnull
    public String getValidResponseCodes() {
        return this.validResponseCodes;
    }

    public String getValidResponseContent() {
        return this.validResponseContent;
    }

    public MimeType getAcceptType() {
        return this.acceptType;
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean getSkipWaitingForSet() {
        return this.skipWaitingForSet;
    }

    @DataBoundSetter
    public void setSkipWaitingForSet(Boolean skipWaitingForSet) {
        this.skipWaitingForSet = skipWaitingForSet;
    }

    public Boolean getConsoleLogResponseBody() {
        return this.consoleLogResponseBody;
    }

    @DataBoundSetter
    public void setConsoleLogResponseBody(Boolean consoleLogResponseBody) {
        this.consoleLogResponseBody = consoleLogResponseBody;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public List<HttpRequestNameValuePair> getCustomHeaders() {
        return this.customHeaders;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
        Items.XSTREAM2.aliasField("logResponseBody", IspwRestApiRequest.class, "consoleLogResponseBody");
        Items.XSTREAM2.aliasField("consoleLogResponseBody", IspwRestApiRequest.class, "consoleLogResponseBody");
        Items.XSTREAM2.aliasField("skipWaitingForSet", IspwRestApiRequest.class, "skipWaitingForSet");
        Items.XSTREAM2.alias("pair", HttpRequestNameValuePair.class);
    }

    protected Object readResolve() {
        if (this.customHeaders == null) {
            this.customHeaders = DescriptorImpl.customHeaders;
        }
        if (this.validResponseCodes == null || this.validResponseCodes.trim().isEmpty()) {
            this.validResponseCodes = "100:399";
        }
        if (this.ignoreSslErrors == null) {
            this.ignoreSslErrors = true;
        }
        return this;
    }

    private List<HttpRequestNameValuePair> createParams(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) {
        Map buildVariables = build.getBuildVariables();
        if (buildVariables.isEmpty()) {
            return Collections.emptyList();
        }
        PrintStream logger = listener.getLogger();
        logger.println("Parameters: ");
        ArrayList<HttpRequestNameValuePair> l = new ArrayList<HttpRequestNameValuePair>();
        for (Map.Entry entry : buildVariables.entrySet()) {
            String value = envVars.expand((String)entry.getValue());
            logger.println("  " + (String)entry.getKey() + " = " + value);
            l.add(new HttpRequestNameValuePair((String)entry.getKey(), value));
        }
        return l;
    }

    String resolveUrl(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) throws IOException {
        List<HttpRequestNameValuePair> params;
        String url = envVars.expand(this.getUrl());
        if (Boolean.TRUE.equals(this.getPassBuildParameters()) && this.getHttpMode() == HttpMode.GET && !(params = this.createParams(envVars, build, listener)).isEmpty()) {
            url = HttpClientUtil.appendParamsToUrl(url, params);
        }
        return url;
    }

    List<HttpRequestNameValuePair> resolveHeaders(EnvVars envVars) {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        headers.add(new HttpRequestNameValuePair("Content-type", MimeType.APPLICATION_JSON.toString()));
        headers.add(new HttpRequestNameValuePair("Authorization", this.getToken()));
        if (this.acceptType != null && this.acceptType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Accept", this.acceptType.getValue()));
        }
        for (HttpRequestNameValuePair header : this.customHeaders) {
            String headerName = envVars.expand(header.getName());
            String headerValue = envVars.expand(header.getValue());
            boolean maskValue = headerName.equalsIgnoreCase("Authorization") || header.getMaskValue();
            headers.add(new HttpRequestNameValuePair(headerName, headerValue, maskValue));
        }
        return headers;
    }

    String resolveBody(EnvVars envVars, AbstractBuild<?, ?> build, TaskListener listener) throws IOException {
        List<HttpRequestNameValuePair> params;
        String body = envVars.expand(this.getRequestBody());
        if (Strings.isNullOrEmpty((String)body) && Boolean.TRUE.equals(this.getPassBuildParameters()) && !(params = this.createParams(envVars, build, listener)).isEmpty()) {
            body = HttpClientUtil.paramsToString(params);
        }
        return body;
    }

    FilePath resolveOutputFile(EnvVars envVars, AbstractBuild<?, ?> build) throws AbortException {
        if (this.outputFile == null || this.outputFile.trim().isEmpty()) {
            return null;
        }
        String filePath = envVars.expand(this.outputFile);
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("Could not find workspace to save file outputFile: " + this.outputFile);
        }
        return workspace.child(filePath);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArrayList<String> variables;
        PrintStream logger = listener.getLogger();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        File buildDirectory = build.getRootDir();
        logger.println("buildDirectory: " + buildDirectory.getAbsolutePath());
        String buildTag = (String)envVars.get((Object)"BUILD_TAG");
        WebhookToken webhookToken = WebhookTokenManager.getInstance().get(buildTag);
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...getting buildTag=" + buildTag + ", webhookToken=" + webhookToken);
        }
        IAction action = ReflectUtils.createAction(this.ispwAction, logger);
        this.httpMode = action.getHttpMode();
        if (!ReflectUtils.isActionInstantiated(action)) {
            logger.println("Action:" + this.ispwAction + " is not implemented, please make sure you have the correct ISPW action name");
            return false;
        }
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ispwAction=" + this.ispwAction + ", httpMode=" + (Object)((Object)this.httpMode));
        }
        String cesUrl = RestApiUtils.getCesUrl(this.connectionId, logger);
        String cesIspwHost = RestApiUtils.getIspwHostLabel(this.connectionId);
        String cesIspwToken = RestApiUtils.getCesToken(this.credentialsId, (Item)build.getParent());
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("CES Url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
        }
        IspwRequestBean ispwRequestBean = null;
        FilePath buildParmPath = GitToIspwUtils.getFilePathInVirtualWorkspace(envVars, "automaticBuildParams.txt");
        this.ispwRequestBody = action.preprocess(this.ispwRequestBody, buildParmPath, logger);
        ispwRequestBean = action.getIspwRequestBean(cesIspwHost, this.ispwRequestBody, webhookToken);
        if (ispwRequestBean == null) {
            logger.println("The " + this.ispwAction + " operation is skipped since the build parameters cannot be captured.");
            return true;
        }
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ispwRequestBean=" + ispwRequestBean);
        }
        this.url = cesUrl + ispwRequestBean.getContextPath();
        this.requestBody = ispwRequestBean.getJsonRequest();
        this.token = cesIspwToken;
        if (Boolean.TRUE.equals(this.consoleLogResponseBody)) {
            logger.println();
            logger.println();
            logger.println("### " + this.ispwAction + " - " + "RFC 2616");
            logger.println();
            logger.println((Object)((Object)this.httpMode) + " " + this.url + " HTTP/1.1");
            logger.println("Content-type: " + MimeType.APPLICATION_JSON.getContentType().toString());
            logger.println("Authorization: " + RestApiUtils.maskToken(this.token));
            logger.println("");
            logger.println(this.requestBody);
            logger.println();
            logger.println("###");
            logger.println();
            logger.println();
        }
        if (!(variables = RestApiUtils.getVariables(this.url)).isEmpty()) {
            String errorMsg = "Action failed, need to define the following: " + variables;
            throw new AbortException(errorMsg);
        }
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            envVars.put((String)e.getKey(), (String)e.getValue());
            if (!RestApiUtils.isIspwDebugMode()) continue;
            logger.println("EnvVars: " + (String)e.getKey() + "=" + (String)e.getValue());
        }
        logger.println("Starting ISPW Operations Plugin");
        action.startLog(logger, ispwRequestBean.getIspwContextPathBean(), ispwRequestBean.getJsonObject());
        HttpRequestExecution exec = HttpRequestExecution.from(this, envVars, build, (TaskListener)listener);
        VirtualChannel channel = launcher.getChannel();
        if (channel == null) {
            logger.println("virtual channel is null, quit");
            return false;
        }
        ResponseContentSupplier supplier = (ResponseContentSupplier)channel.call((Callable)exec);
        if (supplier.getAbortStatus()) {
            if (!supplier.getAbortMessage().isEmpty()) {
                logger.println(supplier.getAbortMessage());
            }
            return false;
        }
        String responseJson = supplier.getContent();
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("responseJson=" + responseJson);
        }
        Object respObject = action.endLog(logger, ispwRequestBean, responseJson);
        if (Boolean.TRUE.equals(this.skipWaitingForSet)) {
            logger.println("Skip waiting for the completion of the set for this job...");
        }
        if (webhookToken == null && !this.skipWaitingForSet.booleanValue()) {
            String setId = "";
            if (respObject instanceof TaskResponse) {
                TaskResponse taskResp = (TaskResponse)respObject;
                setId = taskResp.getSetId();
            } else if (respObject instanceof BuildResponse) {
                BuildResponse buildResp = (BuildResponse)respObject;
                setId = buildResp.getSetId();
            }
            if (StringUtils.isNotBlank((String)setId) && (respObject instanceof TaskResponse || respObject instanceof BuildResponse)) {
                int i;
                HashSet<String> set = new HashSet<String>();
                SetInfoResponse finalSetInfoResp = null;
                boolean isSetHeld = false;
                String setState = "Unknown";
                for (i = 0; i < 60; ++i) {
                    Thread.sleep(2000L);
                    HttpRequestExecution poller = HttpRequestExecution.createPoller(setId, this, envVars, build, (TaskListener)listener);
                    ResponseContentSupplier pollerSupplier = (ResponseContentSupplier)channel.call((Callable)poller);
                    String pollingJson = pollerSupplier.getContent();
                    JsonProcessor jsonProcessor = new JsonProcessor();
                    SetInfoResponse setInfoResp = jsonProcessor.parse(pollingJson, SetInfoResponse.class);
                    setState = StringUtils.trimToEmpty((String)setInfoResp.getState());
                    if (set.contains(setState)) continue;
                    logger.println("ISPW: Set " + setInfoResp.getSetid() + " status - " + setState);
                    set.add(setState);
                    if (setState.equals("Closed") || setState.equals("Complete") || setState.equals("Waiting-Approval")) {
                        FilePath tttChangeSet;
                        logger.println("ISPW: Action " + this.ispwAction + " completed");
                        IspwContextPathBean ispwContextPathBean = ispwRequestBean.getIspwContextPathBean();
                        if (ispwContextPathBean == null || !StringUtils.isNotBlank((String)ispwContextPathBean.getLevel())) break;
                        JsonProcessor jsonProcessor1 = new JsonProcessor();
                        String taskLevel = ispwContextPathBean.getLevel();
                        HttpRequestExecution poller1 = HttpRequestExecution.createPoller(setId, taskLevel, this, envVars, build, (TaskListener)listener);
                        ResponseContentSupplier pollerSupplier1 = (ResponseContentSupplier)channel.call((Callable)poller1);
                        String pollingJson1 = pollerSupplier1.getContent();
                        finalSetInfoResp = jsonProcessor1.parse(pollingJson1, SetInfoResponse.class);
                        if (finalSetInfoResp != null && finalSetInfoResp.getTasks() != null) {
                            StringBuilder taskNames = new StringBuilder();
                            finalSetInfoResp.getTasks().forEach(task -> taskNames.append(task.getModuleName() + ", "));
                            logger.println("ISPW tasks: " + taskNames.substring(0, taskNames.lastIndexOf(",")));
                        }
                        ProgramList programList = RestApiUtils.convertSetInfoResp(finalSetInfoResp);
                        String tttJson = programList.toString();
                        if (Boolean.TRUE.equals(this.consoleLogResponseBody)) {
                            logger.println("tttJson=" + tttJson);
                        }
                        if ((tttChangeSet = GitToIspwUtils.getFilePathInVirtualWorkspace(envVars, "changedPrograms.json")).exists()) {
                            logger.println("Deleting the old changed program list at " + tttChangeSet.getRemote());
                            tttChangeSet.delete();
                        }
                        logger.println("Saving the changed program list to " + tttChangeSet.getRemote());
                        tttChangeSet.write(tttJson, "UTF-8");
                        break;
                    }
                    if ("Failed".equalsIgnoreCase(setState)) {
                        String actionName = ispwRequestBean.getIspwContextPathBean().getAction();
                        if (StringUtils.isBlank((String)actionName)) {
                            actionName = action.getClass().getName();
                        }
                        if (!StringUtils.isNotBlank((String)actionName)) break;
                        logger.println(String.format("ISPW: Set " + setId + " - action [%s] failed", actionName));
                        break;
                    }
                    if ("Terminated".equalsIgnoreCase(setState) && "terminate".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                        logger.println("ISPW: Set " + setId + " - successfully terminated");
                        break;
                    }
                    if ("Held".equalsIgnoreCase(setState) && "hold".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                        logger.println("ISPW: Set " + setId + " - successfully held");
                        isSetHeld = true;
                        break;
                    }
                    if ("Held".equalsIgnoreCase(setState) && "unlock".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                        logger.println("ISPW: Set " + setId + " - successfully unlocked.  Set is currently held.");
                        break;
                    }
                    if (!"Released".equalsIgnoreCase(setState) && !"Waiting-Lock".equalsIgnoreCase(setState) || !"release".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) continue;
                    logger.println("ISPW: Set " + setId + " - successfully released");
                    break;
                }
                if (i == 60) {
                    logger.println("Warn - max timeout reached");
                    return true;
                }
                if (!isSetHeld) {
                    if (respObject instanceof BuildResponse) {
                        return this.buildActionTaskInfoLogger(setId, setState, launcher, envVars, build, listener, logger, respObject);
                    }
                    if (finalSetInfoResp != null) {
                        this.logActionResults(finalSetInfoResp, action, logger);
                    }
                }
            }
        }
        return true;
    }

    private boolean buildActionTaskInfoLogger(String setId, String setState, Launcher launcher, EnvVars envVars, AbstractBuild<?, ?> build, BuildListener listener, PrintStream logger, Object respObject) throws InterruptedException, IOException {
        boolean isSuccessful = false;
        if (setState.equals("Closed") || setState.equals("Complete")) {
            isSuccessful = true;
            Thread.sleep(2000L);
            HttpRequestExecution poller = HttpRequestExecution.createTaskInfoPoller(setId, this, envVars, build, listener);
            VirtualChannel channel = launcher.getChannel();
            if (channel != null) {
                List<TaskInfo> tasksBuilt;
                ResponseContentSupplier pollerSupplier = (ResponseContentSupplier)channel.call((Callable)poller);
                String pollingJson = pollerSupplier.getContent();
                JsonProcessor jsonProcessor = new JsonProcessor();
                TaskListResponse taskListResp = jsonProcessor.parse(pollingJson, TaskListResponse.class);
                BuildResponse buildResponse = (BuildResponse)respObject;
                if (buildResponse.getTasksBuilt().size() == 1) {
                    logger.println("ISPW: Set " + setId + " - " + buildResponse.getTasksBuilt().size() + " task will be built");
                } else {
                    logger.println("ISPW: Set " + setId + " - " + buildResponse.getTasksBuilt().size() + " tasks will be built");
                }
                List<TaskInfo> tasksNotBuilt = tasksBuilt = buildResponse.getTasksBuilt();
                List<TaskInfo> tasksInSet = taskListResp.getTasks();
                int numTasksToBeBuilt = tasksBuilt.size();
                HashSet<String> uniqueTasksInSet = new HashSet<String>();
                if (!tasksInSet.isEmpty()) {
                    for (TaskInfo task : tasksInSet) {
                        if (task.getOperation().startsWith("G")) {
                            logger.println("ISPW: " + task.getModuleName() + " generated successfully");
                        }
                        uniqueTasksInSet.add(task.getTaskId());
                        tasksNotBuilt.removeIf(x -> x.getTaskId().equals(task.getTaskId()));
                    }
                    for (TaskInfo task : tasksNotBuilt) {
                        logger.println("ISPW: " + task.getModuleName() + " did not generate successfully");
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("ISPW: " + uniqueTasksInSet.size() + " of " + numTasksToBeBuilt + " generated successfully. " + tasksNotBuilt.size() + " of " + numTasksToBeBuilt + " generated with errors.\n");
                    if (!tasksNotBuilt.isEmpty()) {
                        isSuccessful = false;
                        logger.println(sb);
                        logger.println("ISPW: The build process completed with generate errors.");
                        throw new AbortException("ISPW: Set processing has not generated successfully.");
                    }
                    logger.println(sb);
                }
            }
        } else {
            throw new AbortException("ISPW: Set processing has not completed successfully. Set status is " + setState + ".");
        }
        logger.println("ISPW: The build process completed.");
        return isSuccessful;
    }

    private void logActionResults(SetInfoResponse finalSetInfoResp, IAction action, PrintStream logger) throws AbortException {
        if (action instanceof SetInfoPostAction) {
            String setState = StringUtils.trimToEmpty((String)finalSetInfoResp.getState());
            SetInfoPostAction setAction = (SetInfoPostAction)action;
            Operation operation = setAction.getIspwOperation();
            List<TaskInfo> tasksInSet = finalSetInfoResp.getTasks();
            boolean bGenerateAction = action instanceof GenerateTaskAction || action instanceof GenerateTasksInAssignmentAction || action instanceof GenerateTasksInReleaseAction;
            boolean showActionSuccessfulMsg = true;
            if (bGenerateAction && !setState.equals("Closed") && !setState.equals("Complete")) {
                showActionSuccessfulMsg = false;
            }
            if (tasksInSet != null) {
                for (TaskInfo task : tasksInSet) {
                    if (!task.getOperation().startsWith(operation.getCode()) || !showActionSuccessfulMsg) continue;
                    logger.println("ISPW: " + task.getModuleName() + " " + operation.getPastTenseDescription() + " successfully.");
                }
            }
            if (setState.equals("Closed") || setState.equals("Complete") || setState.equals("Waiting-Approval")) {
                if (!bGenerateAction || bGenerateAction && (setState.equals("Closed") || setState.equals("Complete"))) {
                    logger.println("ISPW: The " + this.ispwAction + " process completed.");
                } else {
                    logger.println("ISPW: The " + this.ispwAction + " process waits for an approval.");
                }
            } else {
                throw new AbortException("ISPW: Set processing has not completed successfully. Set status is " + setState + ".");
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final boolean ignoreSslErrors = false;
        public static final HttpMode httpMode = HttpMode.POST;
        public static final String httpProxy = "";
        public static final Boolean passBuildParameters = false;
        public static final String validResponseCodes = "100:399";
        public static final String validResponseContent = "";
        public static final MimeType acceptType = MimeType.NOT_SET;
        public static final MimeType contentType = MimeType.NOT_SET;
        public static final String outputFile = "";
        public static final int timeout = 0;
        public static final Boolean quiet = false;
        public static final String authentication = "";
        public static final String requestBody = "";
        public static final String token = "";
        public static final String connectionId = "";
        public static final String credentialsId = "";
        public static final String ispwAction = "";
        public static final String ispwRequestBody = "#The following messages are commented out to show how to use the 'Request' field.\n#Click on the help button to the right of the screen for examples of how to populate this field based on 'Action' type\n#\n#For example, if you select GenerateTasksInAssignment for 'Action' field,\n# you may populate the following properties in 'Request' field.\n# The property value should be based on your own container ID and level.\n#\n#assignmentId=PLAY000313\n#level=STG2\n";
        public static final Boolean consoleLogResponseBody = false;
        public static final Boolean skipWaitingForSet = false;
        public static final List<HttpRequestNameValuePair> customHeaders = Collections.emptyList();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute a Compuware ISPW Operation";
        }

        public ListBoxModel doFillHttpModeItems() {
            return HttpMode.getFillItems();
        }

        public ListBoxModel doFillIspwActionItems(@AncestorInPath Jenkins context, @QueryParameter String ispwAction, @AncestorInPath Item project) {
            return RestApiUtils.buildIspwActionItems(context, ispwAction, project);
        }

        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            return RestApiUtils.buildConnectionIdItems(context, connectionId, project);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            return RestApiUtils.buildCredentialsIdItems(context, credentialsId, project);
        }

        public ListBoxModel doFillAcceptTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillContentTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            return DescriptorImpl.fillAuthenticationItems(project, url);
        }

        public static ListBoxModel fillAuthenticationItems(Item project, String url) {
            if (project == null || !project.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            ArrayList<ListBoxModel.Option> options = new ArrayList<ListBoxModel.Option>();
            for (BasicDigestAuthentication basic : HttpRequestGlobalConfig.get().getBasicDigestAuthentications()) {
                options.add(new ListBoxModel.Option("(deprecated - use Jenkins Credentials) " + basic.getKeyName(), basic.getKeyName()));
            }
            for (FormAuthentication formAuthentication : HttpRequestGlobalConfig.get().getFormAuthentications()) {
                options.add(new ListBoxModel.Option(formAuthentication.getKeyName()));
            }
            AbstractIdCredentialsListBoxModel items = new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, project, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)url).build());
            items.addMissing(options);
            return items;
        }

        public static List<Range<Integer>> parseToRange(String value) {
            String[] codes;
            ArrayList<Range<Integer>> validRanges = new ArrayList<Range<Integer>>();
            for (String code : codes = value.split(",")) {
                Integer from;
                String[] fromTo = code.trim().split(":");
                Preconditions.checkArgument((fromTo.length <= 2 ? 1 : 0) != 0, (String)"Code %s should be an interval from:to or a single value", (Object[])new Object[]{code});
                try {
                    from = Integer.parseInt(fromTo[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid number " + fromTo[0]);
                }
                Integer to = from;
                if (fromTo.length != 1) {
                    try {
                        to = Integer.parseInt(fromTo[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Invalid number " + fromTo[1]);
                    }
                }
                Preconditions.checkArgument((from <= to ? 1 : 0) != 0, (String)"Interval %s should be FROM less than TO", (Object[])new Object[]{code});
                validRanges.add((Range<Integer>)Range.closed((Comparable)from, (Comparable)to));
            }
            return validRanges;
        }

        public FormValidation doCheckValidResponseCodes(@QueryParameter String value) {
            return DescriptorImpl.checkValidResponseCodes(value);
        }

        public static FormValidation checkValidResponseCodes(String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                DescriptorImpl.parseToRange(value);
            }
            catch (IllegalArgumentException iae) {
                return FormValidation.error((String)("Response codes expected is wrong. " + iae.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

